/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.logging.LogLevel;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.util.Clock;

public class BuildResultLogger
extends BuildAdapter {
    private final StyledTextOutputFactory textOutputFactory;
    private final Clock buildTimeClock;

    public BuildResultLogger(StyledTextOutputFactory styledTextOutputFactory, Clock clock) {
        this.textOutputFactory = styledTextOutputFactory;
        this.buildTimeClock = clock;
    }

    public void buildFinished(BuildResult buildResult) {
        StyledTextOutput styledTextOutput = this.textOutputFactory.create(BuildResultLogger.class, LogLevel.LIFECYCLE);
        styledTextOutput.println();
        if (buildResult.getFailure() == null) {
            styledTextOutput.withStyle(StyledTextOutput.Style.Success).text("BUILD SUCCESSFUL");
        } else {
            styledTextOutput.withStyle(StyledTextOutput.Style.Failure).text("BUILD FAILED");
        }
        styledTextOutput.println();
        styledTextOutput.println();
        styledTextOutput.formatln("Total time: %s", this.buildTimeClock.getTime());
    }
}

