/*
 * Decompiled with CFR 0.152.
 */
package org.gradle;

import org.codehaus.groovy.runtime.StackTraceUtils;
import org.gradle.BuildAdapter;
import org.gradle.BuildResult;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.internal.LocationAwareException;
import org.gradle.api.logging.LogLevel;
import org.gradle.execution.TaskSelectionException;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.logging.LoggingConfiguration;
import org.gradle.logging.ShowStacktrace;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.logging.internal.BufferingStyledTextOutput;
import org.gradle.logging.internal.LinePrefixingStyledTextOutput;
import org.gradle.util.GUtil;
import org.gradle.util.TreeVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildExceptionReporter
extends BuildAdapter
implements Action<Throwable> {
    private final StyledTextOutputFactory textOutputFactory;
    private final LoggingConfiguration loggingConfiguration;
    private final BuildClientMetaData clientMetaData;

    public BuildExceptionReporter(StyledTextOutputFactory styledTextOutputFactory, LoggingConfiguration loggingConfiguration, BuildClientMetaData buildClientMetaData) {
        this.textOutputFactory = styledTextOutputFactory;
        this.loggingConfiguration = loggingConfiguration;
        this.clientMetaData = buildClientMetaData;
    }

    @Override
    public void buildFinished(BuildResult buildResult) {
        Throwable throwable = buildResult.getFailure();
        if (throwable == null) {
            return;
        }
        this.execute(throwable);
    }

    @Override
    public void execute(Throwable throwable) {
        FailureDetails failureDetails = new FailureDetails(throwable);
        if (throwable instanceof GradleException) {
            this.reportBuildFailure((GradleException)throwable, failureDetails);
        } else {
            this.reportInternalError(failureDetails);
        }
        this.write(failureDetails);
    }

    protected void write(FailureDetails failureDetails) {
        StyledTextOutput styledTextOutput = this.textOutputFactory.create(BuildExceptionReporter.class, LogLevel.ERROR);
        styledTextOutput.println();
        styledTextOutput.withStyle(StyledTextOutput.Style.Failure).text("FAILURE: ");
        failureDetails.summary.writeTo(styledTextOutput.withStyle(StyledTextOutput.Style.Failure));
        if (failureDetails.location.getHasContent()) {
            styledTextOutput.println().println();
            styledTextOutput.println("* Where:");
            failureDetails.location.writeTo(styledTextOutput);
        }
        if (failureDetails.details.getHasContent()) {
            styledTextOutput.println().println();
            styledTextOutput.println("* What went wrong:");
            failureDetails.details.writeTo(styledTextOutput);
        }
        if (failureDetails.resolution.getHasContent()) {
            styledTextOutput.println().println();
            styledTextOutput.println("* Try:");
            failureDetails.resolution.writeTo(styledTextOutput);
        }
        Throwable throwable = null;
        switch (failureDetails.exceptionStyle) {
            case NONE: {
                break;
            }
            case SANITIZED: {
                throwable = StackTraceUtils.deepSanitize((Throwable)failureDetails.failure);
                break;
            }
            case FULL: {
                throwable = failureDetails.failure;
            }
        }
        if (throwable != null) {
            styledTextOutput.println().println();
            styledTextOutput.println("* Exception is:");
            styledTextOutput.exception(throwable);
        }
        styledTextOutput.println();
    }

    public void reportInternalError(FailureDetails failureDetails) {
        failureDetails.summary.text("Build aborted because of an internal error.");
        failureDetails.details.text("Build aborted because of an unexpected internal error. Please file an issue at: http://forums.gradle.org.");
        if (this.loggingConfiguration.getLogLevel() != LogLevel.DEBUG) {
            failureDetails.resolution.text("Run with ");
            failureDetails.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "debug");
            failureDetails.resolution.text(" option to get additional debug info.");
            failureDetails.exceptionStyle = ExceptionStyle.FULL;
        }
    }

    private void reportBuildFailure(GradleException gradleException, FailureDetails failureDetails) {
        if (this.loggingConfiguration.getShowStacktrace() == ShowStacktrace.ALWAYS || this.loggingConfiguration.getLogLevel() == LogLevel.DEBUG) {
            failureDetails.exceptionStyle = ExceptionStyle.SANITIZED;
        }
        if (this.loggingConfiguration.getShowStacktrace() == ShowStacktrace.ALWAYS_FULL) {
            failureDetails.exceptionStyle = ExceptionStyle.FULL;
        }
        if (gradleException instanceof TaskSelectionException) {
            this.formatTaskSelectionFailure((TaskSelectionException)gradleException, failureDetails);
        } else {
            this.formatGenericFailure(gradleException, failureDetails);
        }
    }

    private void formatTaskSelectionFailure(TaskSelectionException taskSelectionException, FailureDetails failureDetails) {
        assert (taskSelectionException.getCause() == null);
        failureDetails.summary.text("Could not determine which tasks to execute.");
        failureDetails.details.text(this.getMessage(taskSelectionException));
        failureDetails.resolution.text("Run ");
        this.clientMetaData.describeCommand(failureDetails.resolution.withStyle(StyledTextOutput.Style.UserInput), "tasks");
        failureDetails.resolution.text(" to get a list of available tasks.");
    }

    private void formatGenericFailure(GradleException gradleException, final FailureDetails failureDetails) {
        failureDetails.summary.text("Build failed with an exception.");
        this.fillInFailureResolution(failureDetails);
        if (gradleException instanceof LocationAwareException) {
            final LocationAwareException locationAwareException = (LocationAwareException)gradleException;
            failureDetails.failure = locationAwareException.getCause();
            if (locationAwareException.getLocation() != null) {
                failureDetails.location.text(locationAwareException.getLocation());
            }
            locationAwareException.visitReportableCauses((TreeVisitor<? super Throwable>)new TreeVisitor<Throwable>(){
                int depth;

                @Override
                public void node(Throwable throwable) {
                    if (throwable == locationAwareException) {
                        failureDetails.details.text(locationAwareException.getOriginalMessage());
                    } else {
                        failureDetails.details.format("%n", new Object[0]);
                        StringBuilder stringBuilder = new StringBuilder();
                        for (int i = 1; i < this.depth; ++i) {
                            stringBuilder.append("   ");
                        }
                        failureDetails.details.text(stringBuilder);
                        stringBuilder.append("  ");
                        failureDetails.details.style(StyledTextOutput.Style.Info).text("> ").style(StyledTextOutput.Style.Normal);
                        LinePrefixingStyledTextOutput linePrefixingStyledTextOutput = new LinePrefixingStyledTextOutput(failureDetails.details, stringBuilder);
                        linePrefixingStyledTextOutput.text(BuildExceptionReporter.this.getMessage(throwable));
                    }
                }

                @Override
                public void startChildren() {
                    ++this.depth;
                }

                @Override
                public void endChildren() {
                    --this.depth;
                }
            });
        } else {
            failureDetails.details.text(this.getMessage(gradleException));
        }
    }

    private void fillInFailureResolution(FailureDetails failureDetails) {
        if (failureDetails.exceptionStyle == ExceptionStyle.NONE) {
            failureDetails.resolution.text("Run with ");
            failureDetails.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "stacktrace");
            failureDetails.resolution.text(" option to get the stack trace. ");
        }
        if (this.loggingConfiguration.getLogLevel() != LogLevel.DEBUG) {
            failureDetails.resolution.text("Run with ");
            if (this.loggingConfiguration.getLogLevel() != LogLevel.INFO) {
                failureDetails.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "info");
                failureDetails.resolution.text(" or ");
            }
            failureDetails.resolution.withStyle(StyledTextOutput.Style.UserInput).format("--%s", "debug");
            failureDetails.resolution.text(" option to get more log output.");
        }
    }

    private String getMessage(Throwable throwable) {
        String string = throwable.getMessage();
        if (GUtil.isTrue(string)) {
            return string;
        }
        return String.format("%s (no error message)", throwable.getClass().getName());
    }

    private static class FailureDetails {
        Throwable failure;
        final BufferingStyledTextOutput summary = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput details = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput location = new BufferingStyledTextOutput();
        final BufferingStyledTextOutput resolution = new BufferingStyledTextOutput();
        ExceptionStyle exceptionStyle = ExceptionStyle.NONE;

        public FailureDetails(Throwable throwable) {
            this.failure = throwable;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ExceptionStyle {
        NONE,
        SANITIZED,
        FULL;

    }
}

