/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.messaging.remote.internal.protocol;

public class ProducerAvailable extends ParticipantAvailable {
    public ProducerAvailable(Object id, String displayName, String channelKey) {
        super(id, displayName, channelKey);
    }

    public RouteUnavailableMessage getUnavailableMessage() {
        return new ProducerUnavailable(getId());
    }

    public boolean acceptIncoming(RouteAvailableMessage message) {
        if (message instanceof ConsumerAvailable) {
            ConsumerAvailable consumerAvailable = (ConsumerAvailable) message;
            return consumerAvailable.getChannelKey().equals(getChannelKey());
        }
        return false;
    }
}
