/*
 * Copyright 2011 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.gradle.api.internal.artifacts;

import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.internal.Factory;
import org.gradle.api.internal.artifacts.configurations.ConfigurationContainerInternal;

public interface DependencyResolutionServices {
    RepositoryHandler getResolveRepositoryHandler();

    ConfigurationContainerInternal getConfigurationContainer();

    DependencyHandler getDependencyHandler();

    ArtifactHandler getArtifactHandler();

    Factory<ArtifactPublicationServices> getPublishServicesFactory();
}
