/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

public class OperatingSystem {
    private static final OperatingSystem WINDOWS = new OperatingSystem(){

        public boolean isCaseSensitiveFileSystem() {
            return false;
        }

        public boolean isWindows() {
            return true;
        }

        public String getScriptName(String scriptPath) {
            if (scriptPath.toLowerCase().endsWith(".bat")) {
                return scriptPath;
            }
            return scriptPath + ".bat";
        }
    };
    private static final OperatingSystem OS_X = new OperatingSystem(){

        public boolean isCaseSensitiveFileSystem() {
            return false;
        }
    };
    private static final OperatingSystem OTHER = new OperatingSystem();
    private static final OperatingSystem CURRENT;

    public static OperatingSystem current() {
        return CURRENT;
    }

    public String toString() {
        return String.format("%s %s %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
    }

    public boolean isWindows() {
        return false;
    }

    public boolean isUnix() {
        return !this.isWindows();
    }

    public boolean isCaseSensitiveFileSystem() {
        return true;
    }

    public String getScriptName(String scriptPath) {
        return scriptPath;
    }

    static {
        String osName = System.getProperty("os.name").toLowerCase();
        CURRENT = osName.contains("windows") ? WINDOWS : (osName.contains("mac os x") ? OS_X : OTHER);
    }
}

