/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathUtil {
    public static void addUrl(URLClassLoader classLoader, Iterable<URL> classpathElements) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            for (URL classpathElement : classpathElements) {
                method.invoke((Object)classLoader, classpathElement);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Error, could not add URL to system classloader", t);
        }
    }

    public static List<URL> getClasspath(ClassLoader classLoader) {
        ArrayList<URL> implementationClassPath = new ArrayList<URL>();
        for (ClassLoader cl = classLoader; cl != ClassLoader.getSystemClassLoader().getParent(); cl = cl.getParent()) {
            if (!(cl instanceof URLClassLoader)) continue;
            implementationClassPath.addAll(Arrays.asList(((URLClassLoader)cl).getURLs()));
        }
        return implementationClassPath;
    }
}

