/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures;

import java.io.File;
import java.io.IOException;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.ClassPathProvider;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.DefaultClassPathRegistry;
import org.gradle.api.internal.Factory;
import org.gradle.api.internal.GradleDistributionLocator;
import org.gradle.api.internal.project.DefaultIsolatedAntBuilder;
import org.gradle.api.internal.project.DefaultServiceRegistry;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.TopLevelBuildServiceRegistry;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.LoggingManager;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.cache.AutoCloseCacheFactory;
import org.gradle.cache.CacheFactory;
import org.gradle.cache.DefaultCacheFactory;
import org.gradle.configuration.GradleLauncherMetaData;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.ClassLoaderFactory;
import org.gradle.initialization.DefaultClassLoaderFactory;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.DefaultProjectDescriptorRegistry;
import org.gradle.invocation.DefaultGradle;
import org.gradle.listener.DefaultListenerManager;
import org.gradle.listener.ListenerManager;
import org.gradle.logging.LoggingManagerInternal;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.StyledTextOutputFactory;
import org.gradle.logging.internal.DefaultProgressLoggerFactory;
import org.gradle.logging.internal.DefaultStyledTextOutputFactory;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.ProgressListener;
import org.gradle.util.GFileUtils;
import org.gradle.util.TrueTimeProvider;

public class ProjectBuilder {
    private static final GlobalTestServices GLOBAL_SERVICES = new GlobalTestServices();
    private File projectDir;

    public static ProjectBuilder builder() {
        return new ProjectBuilder();
    }

    public ProjectBuilder withProjectDir(File dir) {
        this.projectDir = GFileUtils.canonicalise(dir);
        return this;
    }

    public Project build() {
        if (this.projectDir == null) {
            try {
                this.projectDir = GFileUtils.canonicalise(File.createTempFile("gradle", "projectDir"));
                this.projectDir.delete();
                this.projectDir.mkdir();
                this.projectDir.deleteOnExit();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        File homeDir = new File(this.projectDir, "gradleHome");
        StartParameter startParameter = new StartParameter();
        startParameter.setGradleUserHomeDir(new File(this.projectDir, "userHome"));
        TestTopLevelBuildServiceRegistry topLevelRegistry = new TestTopLevelBuildServiceRegistry(startParameter, homeDir);
        DefaultGradle gradle = new DefaultGradle(null, startParameter, topLevelRegistry);
        DefaultProjectDescriptor projectDescriptor = new DefaultProjectDescriptor(null, "test", this.projectDir, new DefaultProjectDescriptorRegistry());
        ProjectInternal project = topLevelRegistry.get(IProjectFactory.class).createProject(projectDescriptor, null, gradle);
        gradle.setRootProject(project);
        gradle.setDefaultProject(project);
        return project;
    }

    private static class TestTopLevelBuildServiceRegistry
    extends TopLevelBuildServiceRegistry {
        private final File homeDir;

        public TestTopLevelBuildServiceRegistry(StartParameter startParameter, File homeDir) {
            super(GLOBAL_SERVICES, startParameter);
            this.homeDir = homeDir;
        }

        protected BuildClientMetaData createClientMetaData() {
            return new GradleLauncherMetaData();
        }

        protected GradleDistributionLocator createGradleDistributionLocator() {
            return new GradleDistributionLocator(){

                public File getGradleHome() {
                    return TestTopLevelBuildServiceRegistry.this.homeDir;
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GlobalTestServices
    extends DefaultServiceRegistry {
        private GlobalTestServices() {
        }

        protected ListenerManager createListenerManager() {
            return new DefaultListenerManager();
        }

        protected ClassPathRegistry createClassPathRegistry() {
            return new DefaultClassPathRegistry(new ClassPathProvider[0]);
        }

        protected ClassLoaderFactory createClassLoaderFactory() {
            return new DefaultClassLoaderFactory(this.get(ClassPathRegistry.class));
        }

        protected CacheFactory createCacheFactory() {
            return new AutoCloseCacheFactory(new DefaultCacheFactory());
        }

        protected ProgressLoggerFactory createProgressLoggerFactory() {
            return new DefaultProgressLoggerFactory(this.get(ListenerManager.class).getBroadcaster(ProgressListener.class), new TrueTimeProvider());
        }

        protected Factory<LoggingManagerInternal> createLoggingManagerFactory() {
            return new Factory<LoggingManagerInternal>(){

                @Override
                public LoggingManagerInternal create() {
                    return new NoOpLoggingManager();
                }
            };
        }

        protected StyledTextOutputFactory createStyledTextOutputFactory() {
            return new DefaultStyledTextOutputFactory(this.get(ListenerManager.class).getBroadcaster(OutputEventListener.class), new TrueTimeProvider());
        }

        protected IsolatedAntBuilder createIsolatedAntBuilder() {
            return new DefaultIsolatedAntBuilder(this.get(ClassPathRegistry.class));
        }
    }

    private static class NoOpLoggingManager
    implements LoggingManagerInternal {
        private LogLevel stdoutLevel = LogLevel.LIFECYCLE;

        private NoOpLoggingManager() {
        }

        public LoggingManagerInternal captureStandardOutput(LogLevel level) {
            this.stdoutLevel = level;
            return this;
        }

        public LoggingManager disableStandardOutputCapture() {
            this.stdoutLevel = null;
            return this;
        }

        public boolean isStandardOutputCaptureEnabled() {
            return this.stdoutLevel != null;
        }

        public LogLevel getStandardOutputCaptureLevel() {
            return this.stdoutLevel;
        }

        public LoggingManagerInternal captureStandardError(LogLevel level) {
            return this;
        }

        public LoggingManagerInternal setLevel(LogLevel logLevel) {
            return this;
        }

        public LogLevel getStandardErrorCaptureLevel() {
            return LogLevel.ERROR;
        }

        public LoggingManagerInternal start() {
            return this;
        }

        public LoggingManagerInternal stop() {
            return this;
        }

        public void addStandardErrorListener(StandardOutputListener listener) {
        }

        public void addStandardOutputListener(StandardOutputListener listener) {
        }

        public void removeStandardOutputListener(StandardOutputListener listener) {
        }

        public void removeStandardErrorListener(StandardOutputListener listener) {
        }

        public void addOutputEventListener(OutputEventListener listener) {
        }

        public void removeOutputEventListener(OutputEventListener listener) {
        }

        public void colorStdOutAndStdErr(boolean colorOutput) {
        }
    }
}

