/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.gradle.BuildListener;
import org.gradle.BuildResult;
import org.gradle.api.Project;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.ProjectState;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.execution.TaskExecutionListener;
import org.gradle.api.initialization.Settings;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.tasks.TaskState;
import org.gradle.profile.BuildProfile;
import org.gradle.profile.HTMLProfileReport;
import org.gradle.profile.ProjectProfile;
import org.gradle.profile.TaskProfile;

public class ProfileListener
implements BuildListener,
ProjectEvaluationListener,
TaskExecutionListener {
    private BuildProfile buildProfile;
    private static final SimpleDateFormat FILE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
    private long profileStarted;

    public ProfileListener(long profileStarted) {
        this.profileStarted = profileStarted;
    }

    public void buildStarted(Gradle gradle) {
        this.buildProfile = new BuildProfile(gradle);
        this.buildProfile.setBuildStarted(System.currentTimeMillis());
        this.buildProfile.setProfilingStarted(this.profileStarted);
    }

    public void settingsEvaluated(Settings settings) {
        this.buildProfile.setSettingsEvaluated(System.currentTimeMillis());
    }

    public void projectsLoaded(Gradle gradle) {
        this.buildProfile.setProjectsLoaded(System.currentTimeMillis());
    }

    public void projectsEvaluated(Gradle gradle) {
        this.buildProfile.setProjectsEvaluated(System.currentTimeMillis());
    }

    public void buildFinished(BuildResult result) {
        this.buildProfile.setBuildFinished(System.currentTimeMillis());
        HTMLProfileReport report = new HTMLProfileReport(this.buildProfile);
        File file = new File(result.getGradle().getRootProject().getBuildDir(), "reports/profile/profile-" + FILE_DATE_FORMAT.format(new Date(this.profileStarted)) + ".html");
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
            report.writeTo(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void beforeEvaluate(Project project) {
        this.buildProfile.getProjectProfile(project).setBeforeEvaluate(System.currentTimeMillis());
    }

    public void afterEvaluate(Project project, ProjectState state) {
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project);
        projectProfile.setAfterEvaluate(System.currentTimeMillis());
        projectProfile.setState(state);
    }

    public void beforeExecute(Task task) {
        Project project = task.getProject();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project);
        projectProfile.getTaskProfile(task).setStart(System.currentTimeMillis());
    }

    public void afterExecute(Task task, TaskState state) {
        Project project = task.getProject();
        ProjectProfile projectProfile = this.buildProfile.getProjectProfile(project);
        TaskProfile taskProfile = projectProfile.getTaskProfile(task);
        taskProfile.setFinish(System.currentTimeMillis());
        taskProfile.setState(state);
    }
}

