/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.text.DecimalFormat;

public class ElapsedTimeFormatter {
    private static final DecimalFormat SECONDS_FORMAT = new DecimalFormat("0.000");
    private static final DecimalFormat SECONDS_FORMAT2 = new DecimalFormat("00.000");
    private static final DecimalFormat HMFORMAT = new DecimalFormat("0");
    private static final DecimalFormat HMFORMAT2 = new DecimalFormat("00");

    public String format(long elapsed) {
        long hours = elapsed / 3600000L;
        long minutes = elapsed / 60000L % 60L;
        float seconds = (float)((double)(elapsed % 60000L) / 1000.0);
        StringBuffer result = new StringBuffer();
        if (hours > 0L) {
            result.append(HMFORMAT.format(hours));
            result.append(":");
        }
        if (minutes > 0L) {
            if (hours > 0L) {
                result.append(HMFORMAT2.format(minutes));
            } else {
                result.append(HMFORMAT.format(minutes));
            }
            result.append(":");
        }
        if (hours > 0L || minutes > 0L) {
            result.append(SECONDS_FORMAT2.format(seconds));
        } else {
            result.append(SECONDS_FORMAT.format(seconds));
        }
        return result.toString();
    }
}

