/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.profile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.profile.ProjectProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildProfile {
    private Gradle gradle;
    Map<Project, ProjectProfile> projects = new HashMap<Project, ProjectProfile>();
    long profilingStarted;
    long buildStarted;
    long settingsEvaluated;
    long projectsLoaded;
    long projectsEvaluated;
    long buildFinished;

    public BuildProfile(Gradle gradle) {
        this.gradle = gradle;
    }

    public Gradle getGradle() {
        return this.gradle;
    }

    public String getTaskDescription() {
        StringBuilder result = new StringBuilder();
        for (String name : this.gradle.getStartParameter().getExcludedTaskNames()) {
            result.append("-x");
            result.append(name);
            result.append(" ");
        }
        for (String name : this.gradle.getStartParameter().getTaskNames()) {
            result.append(name);
            result.append(" ");
        }
        return result.toString();
    }

    public ProjectProfile getProjectProfile(Project project) {
        ProjectProfile result = this.projects.get(project);
        if (result == null) {
            result = new ProjectProfile(project);
            this.projects.put(project, result);
        }
        return result;
    }

    public List<ProjectProfile> getProjects() {
        return new ArrayList<ProjectProfile>(this.projects.values());
    }

    public void setProfilingStarted(long profilingStarted) {
        this.profilingStarted = profilingStarted;
    }

    public void setBuildStarted(long buildStarted) {
        this.buildStarted = buildStarted;
    }

    public void setSettingsEvaluated(long settingsEvaluated) {
        this.settingsEvaluated = settingsEvaluated;
    }

    public void setProjectsLoaded(long projectsLoaded) {
        this.projectsLoaded = projectsLoaded;
    }

    public void setProjectsEvaluated(long projectsEvaluated) {
        this.projectsEvaluated = projectsEvaluated;
    }

    public void setBuildFinished(long buildFinished) {
        this.buildFinished = buildFinished;
    }

    public long getElapsedStartup() {
        return this.buildStarted - this.profilingStarted;
    }

    public long getElapsedTotal() {
        return this.buildFinished - this.profilingStarted;
    }

    public long getElapsedSettings() {
        return this.settingsEvaluated - this.buildStarted;
    }

    public long getElapsedProjectsLoading() {
        return this.projectsLoaded - this.settingsEvaluated;
    }

    public long getElapsedProjectsEvaluated() {
        return this.projectsEvaluated - this.projectsLoaded;
    }

    public long getElapsedAfterProjectsEvaluated() {
        return this.buildFinished - this.projectsEvaluated;
    }

    public long getElapsedTotalExecutionTime() {
        long result = 0L;
        for (ProjectProfile projectProfile : this.projects.values()) {
            result += projectProfile.getElapsedTaskExecution();
        }
        return result;
    }
}

