/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.InputStream;
import java.util.concurrent.Executor;
import org.gradle.messaging.concurrent.DefaultExecutorFactory;
import org.gradle.process.internal.DefaultExecHandle;
import org.gradle.process.internal.ExecOutputHandleRunner;
import org.gradle.process.internal.ProcessBuilderFactory;
import org.gradle.util.DisconnectableInputStream;

public class ExecHandleRunner
implements Runnable {
    private static final Object START_LOCK = new Object();
    private final ProcessBuilderFactory processBuilderFactory;
    private final DefaultExecHandle execHandle;
    private final Executor threadPool;
    private final Object lock;
    private Process process;
    private boolean aborted;

    public ExecHandleRunner(DefaultExecHandle execHandle, Executor threadPool) {
        if (execHandle == null) {
            throw new IllegalArgumentException("execHandle == null!");
        }
        this.processBuilderFactory = new ProcessBuilderFactory();
        this.execHandle = execHandle;
        this.lock = new Object();
        this.threadPool = threadPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWaiting() {
        Object object = this.lock;
        synchronized (object) {
            this.aborted = true;
            if (this.process != null) {
                this.process.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int exitCode;
        ProcessBuilder processBuilder = this.processBuilderFactory.createProcessBuilder(this.execHandle);
        try {
            ExecOutputHandleRunner standardInputRunner;
            ExecOutputHandleRunner errorOutputRunner;
            ExecOutputHandleRunner standardOutputRunner;
            Process process;
            DisconnectableInputStream instr = new DisconnectableInputStream(this.execHandle.getStandardInput(), new DefaultExecutorFactory());
            Object object = START_LOCK;
            synchronized (object) {
                process = processBuilder.start();
                standardOutputRunner = new ExecOutputHandleRunner("read process standard output", process.getInputStream(), this.execHandle.getStandardOutput());
                errorOutputRunner = new ExecOutputHandleRunner("read process error output", process.getErrorStream(), this.execHandle.getErrorOutput());
                standardInputRunner = new ExecOutputHandleRunner("write process standard input", instr, process.getOutputStream());
            }
            object = this.lock;
            synchronized (object) {
                this.process = process;
            }
            this.threadPool.execute(standardInputRunner);
            this.threadPool.execute(standardOutputRunner);
            this.threadPool.execute(errorOutputRunner);
            this.execHandle.started();
            exitCode = process.waitFor();
            ((InputStream)instr).close();
        }
        catch (Throwable t) {
            this.execHandle.failed(t);
            return;
        }
        if (this.aborted) {
            this.execHandle.aborted(exitCode);
        } else {
            this.execHandle.finished(exitCode);
        }
    }
}

