/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.URI;
import org.gradle.api.Action;
import org.gradle.messaging.concurrent.CompositeStoppable;
import org.gradle.messaging.concurrent.DefaultExecutorFactory;
import org.gradle.messaging.remote.ConnectEvent;
import org.gradle.messaging.remote.MessagingClient;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.DefaultMessagingClient;
import org.gradle.messaging.remote.internal.DefaultMultiChannelConnector;
import org.gradle.messaging.remote.internal.IncomingConnector;
import org.gradle.messaging.remote.internal.TcpOutgoingConnector;

public class TcpMessagingClient
implements MessagingClient {
    private final DefaultMultiChannelConnector connector;
    private final DefaultMessagingClient client;
    private final DefaultExecutorFactory executorFactory = new DefaultExecutorFactory();

    public TcpMessagingClient(ClassLoader messagingClassLoader, URI serverAddress) {
        this.connector = new DefaultMultiChannelConnector(new TcpOutgoingConnector(messagingClassLoader), new NoOpIncomingConnector(), this.executorFactory);
        this.client = new DefaultMessagingClient(this.connector, messagingClassLoader, serverAddress);
    }

    public ObjectConnection getConnection() {
        return this.client.getConnection();
    }

    public void stop() {
        new CompositeStoppable(this.client, this.connector, this.executorFactory).stop();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NoOpIncomingConnector
    implements IncomingConnector {
        private NoOpIncomingConnector() {
        }

        @Override
        public URI accept(Action<ConnectEvent<Connection<Object>>> action) {
            throw new UnsupportedOperationException();
        }
    }
}

