/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.remote.internal.MethodMetaInfo;
import org.gradle.messaging.remote.internal.RemoteMethodInvocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvocationUnmarshallingDispatch
implements Dispatch<Object> {
    private final Dispatch<? super MethodInvocation> dispatch;
    private final ClassLoader classLoader;
    private final Map<Object, Method> methods = new HashMap<Object, Method>();

    public MethodInvocationUnmarshallingDispatch(Dispatch<? super MethodInvocation> dispatch, ClassLoader classLoader) {
        this.dispatch = dispatch;
        this.classLoader = classLoader;
    }

    @Override
    public void dispatch(Object message) {
        if (message instanceof MethodMetaInfo) {
            MethodMetaInfo methodMetaInfo = (MethodMetaInfo)message;
            Method method = methodMetaInfo.findMethod(this.classLoader);
            this.methods.put(methodMetaInfo.getKey(), method);
        } else if (message instanceof RemoteMethodInvocation) {
            RemoteMethodInvocation remoteMethodInvocation = (RemoteMethodInvocation)message;
            Method method = this.methods.get(remoteMethodInvocation.getKey());
            if (method == null) {
                throw new IllegalStateException("Received a method invocation message for an unknown method.");
            }
            MethodInvocation methodInvocation = new MethodInvocation(method, remoteMethodInvocation.getArguments());
            this.dispatch.dispatch(methodInvocation);
        } else {
            throw new IllegalStateException(String.format("Received an unknown message %s.", message));
        }
    }
}

