/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.StringUtils;
import org.gradle.messaging.remote.internal.ConnectRequest;
import org.gradle.messaging.remote.internal.Connection;
import org.gradle.messaging.remote.internal.Message;
import org.gradle.messaging.remote.internal.OutgoingConnector;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandshakeOutgoingConnector
implements OutgoingConnector {
    private final OutgoingConnector connector;

    public HandshakeOutgoingConnector(OutgoingConnector connector) {
        this.connector = connector;
    }

    public Connection<Message> connect(URI destinationAddress) {
        if (!destinationAddress.getScheme().equals("channel")) {
            throw new IllegalArgumentException(String.format("Cannot create a connection to destination URI with unknown scheme: %s.", destinationAddress));
        }
        URI connectionAddress = this.toConnectionAddress(destinationAddress);
        Connection<Message> connection = this.connector.connect(connectionAddress);
        try {
            connection.dispatch(new ConnectRequest(destinationAddress));
        }
        catch (Throwable e) {
            connection.stop();
            throw UncheckedException.asUncheckedException(e);
        }
        return connection;
    }

    private URI toConnectionAddress(URI destinationAddress) {
        URI connectionAddress;
        String content = destinationAddress.getSchemeSpecificPart();
        try {
            connectionAddress = new URI(StringUtils.substringBeforeLast((String)content, (String)"!"));
        }
        catch (URISyntaxException e) {
            throw new UncheckedException(e);
        }
        return connectionAddress;
    }
}

