/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.net.URI;
import org.gradle.messaging.concurrent.AsyncStoppable;
import org.gradle.messaging.dispatch.Addressable;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.remote.ObjectConnection;
import org.gradle.messaging.remote.internal.IncomingMethodInvocationHandler;
import org.gradle.messaging.remote.internal.OutgoingMethodInvocationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectConnection
implements ObjectConnection {
    private final Addressable addressable;
    private final AsyncStoppable stopControl;
    private final OutgoingMethodInvocationHandler outgoing;
    private final IncomingMethodInvocationHandler incoming;

    public DefaultObjectConnection(Addressable addressable, AsyncStoppable stopControl, OutgoingMethodInvocationHandler outgoing, IncomingMethodInvocationHandler incoming) {
        this.addressable = addressable;
        this.stopControl = stopControl;
        this.outgoing = outgoing;
        this.incoming = incoming;
    }

    @Override
    public URI getRemoteAddress() {
        return this.addressable.getRemoteAddress();
    }

    @Override
    public URI getLocalAddress() {
        return this.addressable.getLocalAddress();
    }

    @Override
    public <T> void addIncoming(Class<T> type, T instance) {
        this.incoming.addIncoming(type, instance);
    }

    @Override
    public void addIncoming(Class<?> type, Dispatch<? super MethodInvocation> dispatch) {
        this.incoming.addIncoming(type, dispatch);
    }

    @Override
    public <T> T addOutgoing(Class<T> type) {
        return this.outgoing.addOutgoing(type);
    }

    @Override
    public void requestStop() {
        this.stopControl.requestStop();
    }

    @Override
    public void stop() {
        this.stopControl.stop();
    }
}

