/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.remote.internal;

import java.util.HashMap;
import java.util.Map;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.remote.internal.ChannelMessage;
import org.gradle.messaging.remote.internal.ChannelMetaInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelMessageUnmarshallingDispatch
implements Dispatch<Object> {
    private final Dispatch<Object> dispatch;
    private final Map<Integer, Object> channels = new HashMap<Integer, Object>();

    public ChannelMessageUnmarshallingDispatch(Dispatch<Object> dispatch) {
        this.dispatch = dispatch;
    }

    @Override
    public void dispatch(Object message) {
        if (message instanceof ChannelMetaInfo) {
            ChannelMetaInfo metaInfo = (ChannelMetaInfo)message;
            this.channels.put(metaInfo.getChannelId(), metaInfo.getChannelKey());
            return;
        }
        if (message instanceof ChannelMessage) {
            ChannelMessage channelMessage = (ChannelMessage)message;
            this.dispatch.dispatch(new ChannelMessage(this.channels.get(channelMessage.getChannel()), channelMessage.getPayload()));
            return;
        }
        this.dispatch.dispatch(message);
    }
}

