/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.dispatch;

import groovy.lang.Closure;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.listener.ListenerNotificationException;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.ExceptionTrackingListener;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ReflectionDispatch;
import org.gradle.messaging.dispatch.StoppableDispatch;
import org.gradle.util.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BroadcastDispatch<T>
implements StoppableDispatch<MethodInvocation> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BroadcastDispatch.class);
    private final Class<T> type;
    private final Map<Object, Dispatch<MethodInvocation>> handlers = new LinkedHashMap<Object, Dispatch<MethodInvocation>>();

    public BroadcastDispatch(Class<T> type) {
        this.type = type;
    }

    public Class<T> getType() {
        return this.type;
    }

    public void add(Dispatch<MethodInvocation> dispatch) {
        this.handlers.put(dispatch, dispatch);
    }

    public void add(T listener) {
        this.handlers.put(listener, new ReflectionDispatch(listener));
    }

    public void add(String methodName, Closure closure) {
        this.assertIsMethod(methodName);
        this.handlers.put(closure, new ClosureInvocationHandler(methodName, closure));
    }

    public void add(String methodName, Action<?> action) {
        this.assertIsMethod(methodName);
        this.handlers.put(action, new ActionInvocationHandler(methodName, action));
    }

    private void assertIsMethod(String methodName) {
        for (Method method : this.type.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Method %s() not found for listener type %s.", methodName, this.type.getSimpleName()));
    }

    public void remove(Object listener) {
        this.handlers.remove(listener);
    }

    private String getErrorMessage() {
        String typeDescription = this.type.getSimpleName().replaceAll("(\\p{Upper})", " $1").trim().toLowerCase();
        return String.format("Failed to notify %s.", typeDescription);
    }

    @Override
    public void dispatch(MethodInvocation invocation) {
        try {
            ExceptionTrackingListener tracker = new ExceptionTrackingListener(LOGGER);
            for (Dispatch<MethodInvocation> handler : new ArrayList<Dispatch<MethodInvocation>>(this.handlers.values())) {
                try {
                    handler.dispatch(invocation);
                }
                catch (UncheckedException e) {
                    tracker.execute(e.getCause());
                }
                catch (Throwable t) {
                    tracker.execute(t);
                }
            }
            tracker.stop();
        }
        catch (Throwable t) {
            throw new ListenerNotificationException(this.getErrorMessage(), t);
        }
    }

    @Override
    public void stop() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ActionInvocationHandler
    implements Dispatch<MethodInvocation> {
        private final String methodName;
        private final Action action;

        public ActionInvocationHandler(String methodName, Action action) {
            this.methodName = methodName;
            this.action = action;
        }

        @Override
        public void dispatch(MethodInvocation message) {
            if (message.getMethod().getName().equals(this.methodName)) {
                this.action.execute(message.getArguments()[0]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ClosureInvocationHandler
    implements Dispatch<MethodInvocation> {
        private final String methodName;
        private final Closure closure;

        public ClosureInvocationHandler(String methodName, Closure closure) {
            this.methodName = methodName;
            this.closure = closure;
        }

        @Override
        public void dispatch(MethodInvocation message) {
            if (message.getMethod().getName().equals(this.methodName)) {
                Object[] parameters = message.getArguments();
                if (this.closure.getMaximumNumberOfParameters() < parameters.length) {
                    parameters = Arrays.asList(parameters).subList(0, this.closure.getMaximumNumberOfParameters()).toArray();
                }
                this.closure.call(parameters);
            }
        }
    }
}

