/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.concurrent;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.gradle.api.logging.Logging;
import org.gradle.messaging.concurrent.CompositeStoppable;
import org.gradle.messaging.concurrent.ExecutorFactory;
import org.gradle.messaging.concurrent.Stoppable;
import org.gradle.messaging.concurrent.StoppableExecutor;
import org.gradle.messaging.dispatch.ExceptionTrackingListener;
import org.gradle.util.UncheckedException;

public class DefaultExecutorFactory
implements ExecutorFactory,
Stoppable {
    private final Set<StoppableExecutorImpl> executors = new CopyOnWriteArraySet<StoppableExecutorImpl>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        try {
            new CompositeStoppable(this.executors).stop();
        }
        finally {
            this.executors.clear();
        }
    }

    public StoppableExecutor create(String displayName) {
        StoppableExecutorImpl executor = new StoppableExecutorImpl(this.createExecutor(displayName));
        this.executors.add(executor);
        return executor;
    }

    protected ExecutorService createExecutor(String displayName) {
        return Executors.newCachedThreadPool(new ThreadFactoryImpl(displayName));
    }

    private static class ThreadFactoryImpl
    implements ThreadFactory {
        private final AtomicLong counter = new AtomicLong();
        private final String displayName;

        public ThreadFactoryImpl(String displayName) {
            this.displayName = displayName;
        }

        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            long count = this.counter.incrementAndGet();
            if (count == 1L) {
                thread.setName(this.displayName);
            } else {
                thread.setName(String.format("%s Thread %s", this.displayName, count));
            }
            return thread;
        }
    }

    private class StoppableExecutorImpl
    implements StoppableExecutor {
        private final ExecutorService executor;
        private final ExceptionTrackingListener exceptionListener;
        private final ThreadLocal<Runnable> executing = new ThreadLocal();

        public StoppableExecutorImpl(ExecutorService executor) {
            this.executor = executor;
            this.exceptionListener = new ExceptionTrackingListener(Logging.getLogger(StoppableExecutorImpl.class));
        }

        public void execute(final Runnable command) {
            this.executor.execute(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    StoppableExecutorImpl.this.executing.set(command);
                    try {
                        command.run();
                    }
                    catch (Throwable throwable) {
                        StoppableExecutorImpl.this.exceptionListener.execute(throwable);
                    }
                    finally {
                        StoppableExecutorImpl.this.executing.set(null);
                    }
                }
            });
        }

        public void requestStop() {
            this.executor.shutdown();
        }

        public void stop() {
            this.stop(Integer.MAX_VALUE, TimeUnit.SECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop(int timeoutValue, TimeUnit timeoutUnits) throws IllegalStateException {
            this.requestStop();
            if (this.executing.get() != null) {
                throw new IllegalStateException("Cannot stop this executor from an executor thread.");
            }
            try {
                try {
                    if (!this.executor.awaitTermination(timeoutValue, timeoutUnits)) {
                        this.executor.shutdownNow();
                        throw new IllegalStateException("Timeout waiting for concurrent jobs to complete.");
                    }
                }
                catch (InterruptedException e) {
                    throw new UncheckedException(e);
                }
                this.exceptionListener.stop();
            }
            finally {
                DefaultExecutorFactory.this.executors.remove(this);
            }
        }
    }
}

