/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.messaging.concurrent;

import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.gradle.api.UncheckedIOException;
import org.gradle.messaging.concurrent.Stoppable;
import org.gradle.util.GUtil;
import org.gradle.util.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeStoppable
implements Stoppable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeStoppable.class);
    private final List<Stoppable> elements = new CopyOnWriteArrayList<Stoppable>();

    public CompositeStoppable() {
    }

    public CompositeStoppable(Stoppable ... elements) {
        this(Arrays.asList(elements));
    }

    public CompositeStoppable(Iterable<? extends Stoppable> elements) {
        GUtil.addToCollection(this.elements, elements);
    }

    public CompositeStoppable(Closeable ... elements) {
        for (Closeable element : elements) {
            this.add(element);
        }
    }

    public CompositeStoppable add(Iterable<? extends Stoppable> elements) {
        GUtil.addToCollection(this.elements, elements);
        return this;
    }

    public CompositeStoppable add(Stoppable stoppable) {
        this.elements.add(stoppable);
        return this;
    }

    public CompositeStoppable add(Closeable closeable) {
        this.elements.add(this.toStoppable(closeable));
        return this;
    }

    public CompositeStoppable addCloseables(Iterable<? extends Closeable> closeables) {
        for (Closeable closeable : closeables) {
            this.add(closeable);
        }
        return this;
    }

    private Stoppable toStoppable(final Closeable closeable) {
        return new Stoppable(){

            public void stop() {
                try {
                    closeable.close();
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        Throwable failure = null;
        try {
            for (Stoppable element : this.elements) {
                try {
                    element.stop();
                }
                catch (Throwable throwable) {
                    if (failure == null) {
                        failure = throwable;
                        continue;
                    }
                    LOGGER.error(String.format("Could not stop %s.", element), throwable);
                }
            }
        }
        finally {
            this.elements.clear();
        }
        if (failure != null) {
            throw UncheckedException.asUncheckedException(failure);
        }
    }
}

