/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.io.Closeable;
import java.io.IOException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.logging.StandardOutputListener;
import org.gradle.logging.internal.AbstractStyledTextOutput;

public class StreamingStyledTextOutput
extends AbstractStyledTextOutput
implements Closeable {
    private final StandardOutputListener listener;
    private final Closeable closeable;

    public StreamingStyledTextOutput(StandardOutputListener listener) {
        this(listener, listener);
    }

    public StreamingStyledTextOutput(final Appendable appendable) {
        this(appendable, new StandardOutputListener(){

            public void onOutput(CharSequence output) {
                try {
                    appendable.append(output);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
    }

    private StreamingStyledTextOutput(Object target, StandardOutputListener listener) {
        this.listener = listener;
        this.closeable = target instanceof Closeable ? (Closeable)target : null;
    }

    protected void doAppend(String text) {
        this.listener.onOutput(text);
    }

    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
        }
    }
}

