/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import java.util.Iterator;
import java.util.LinkedList;
import org.gradle.api.logging.LogLevel;
import org.gradle.logging.StyledTextOutput;
import org.gradle.logging.internal.OutputEvent;
import org.gradle.logging.internal.OutputEventListener;
import org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.logging.internal.ProgressEvent;
import org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.logging.internal.RenderableOutputEvent;
import org.gradle.logging.internal.StyledTextOutputEvent;

public class ProgressLogEventGenerator
implements OutputEventListener {
    public static final String EOL = System.getProperty("line.separator");
    private final OutputEventListener listener;
    private final boolean deferHeader;
    private final LinkedList<Operation> operations = new LinkedList();

    public ProgressLogEventGenerator(OutputEventListener listener, boolean deferHeader) {
        this.listener = listener;
        this.deferHeader = deferHeader;
    }

    public void onOutput(OutputEvent event) {
        if (event instanceof ProgressStartEvent) {
            this.onStart((ProgressStartEvent)event);
        } else if (event instanceof ProgressCompleteEvent) {
            this.onComplete((ProgressCompleteEvent)event);
        } else if (event instanceof RenderableOutputEvent) {
            this.doOutput((RenderableOutputEvent)event);
        } else if (!(event instanceof ProgressEvent)) {
            this.listener.onOutput(event);
        }
    }

    private void doOutput(RenderableOutputEvent event) {
        for (Operation operation : this.operations) {
            operation.completeHeader();
        }
        this.listener.onOutput(event);
    }

    private void onComplete(ProgressCompleteEvent progressCompleteEvent) {
        assert (!this.operations.isEmpty());
        Operation operation = this.operations.removeLast();
        operation.status = progressCompleteEvent.getStatus();
        operation.completeTime = progressCompleteEvent.getTimestamp();
        operation.complete();
    }

    private void onStart(ProgressStartEvent progressStartEvent) {
        Operation operation = new Operation();
        operation.category = progressStartEvent.getCategory();
        operation.description = progressStartEvent.getDescription();
        operation.startTime = progressStartEvent.getTimestamp();
        operation.status = "";
        this.operations.add(operation);
        if (!this.deferHeader) {
            operation.startHeader();
        }
    }

    private class Operation {
        private String category;
        private String description;
        private String status;
        private State state = State.None;
        public long startTime;
        public long completeTime;

        private Operation() {
        }

        public String getDescription() {
            return this.description;
        }

        public String getStatus() {
            return this.status;
        }

        private void doOutput(RenderableOutputEvent event) {
            Operation pending;
            Iterator i$ = ProgressLogEventGenerator.this.operations.iterator();
            while (i$.hasNext() && (pending = (Operation)i$.next()) != this) {
                pending.completeHeader();
            }
            ProgressLogEventGenerator.this.listener.onOutput(event);
        }

        public void startHeader() {
            boolean hasDescription;
            assert (this.state == State.None);
            boolean bl = hasDescription = this.description.length() > 0;
            if (hasDescription) {
                this.state = State.HeaderStarted;
                this.doOutput(new StyledTextOutputEvent(this.startTime, this.category, LogLevel.LIFECYCLE, this.description));
            } else {
                this.state = State.HeaderCompleted;
            }
        }

        public void completeHeader() {
            boolean hasDescription = this.description.length() > 0;
            switch (this.state) {
                case None: {
                    if (!hasDescription) break;
                    ProgressLogEventGenerator.this.listener.onOutput(new StyledTextOutputEvent(this.startTime, this.category, LogLevel.LIFECYCLE, this.description + EOL));
                    break;
                }
                case HeaderStarted: {
                    ProgressLogEventGenerator.this.listener.onOutput(new StyledTextOutputEvent(this.startTime, this.category, LogLevel.LIFECYCLE, EOL));
                    break;
                }
                case HeaderCompleted: {
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.state = State.HeaderCompleted;
        }

        public void complete() {
            boolean hasStatus = this.status.length() > 0;
            boolean hasDescription = this.description.length() > 0;
            switch (this.state) {
                case None: {
                    if (hasDescription && hasStatus) {
                        this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, new StyledTextOutputEvent.Span(this.description + ' '), new StyledTextOutputEvent.Span(StyledTextOutput.Style.ProgressStatus, this.status), new StyledTextOutputEvent.Span(EOL)));
                        break;
                    }
                    if (hasDescription) {
                        this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, this.description + EOL));
                        break;
                    }
                    if (!hasStatus) break;
                    this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, new StyledTextOutputEvent.Span(StyledTextOutput.Style.ProgressStatus, this.status), new StyledTextOutputEvent.Span(EOL)));
                    break;
                }
                case HeaderStarted: {
                    if (hasStatus) {
                        this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, new StyledTextOutputEvent.Span(" "), new StyledTextOutputEvent.Span(StyledTextOutput.Style.ProgressStatus, this.status), new StyledTextOutputEvent.Span(EOL)));
                        break;
                    }
                    this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, EOL));
                    break;
                }
                case HeaderCompleted: {
                    if (hasDescription && hasStatus) {
                        this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, new StyledTextOutputEvent.Span(this.description + ' '), new StyledTextOutputEvent.Span(StyledTextOutput.Style.ProgressStatus, this.status), new StyledTextOutputEvent.Span(EOL)));
                        break;
                    }
                    if (!hasStatus) break;
                    this.doOutput(new StyledTextOutputEvent(this.completeTime, this.category, LogLevel.LIFECYCLE, new StyledTextOutputEvent.Span(StyledTextOutput.Style.ProgressStatus, this.status), new StyledTextOutputEvent.Span(EOL)));
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            this.state = State.Completed;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum State {
        None,
        HeaderStarted,
        HeaderCompleted,
        Completed;

    }
}

