/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.Collections;
import org.gradle.CommandLineArgumentException;
import org.gradle.api.logging.LogLevel;
import org.gradle.initialization.AbstractCommandLineConverter;
import org.gradle.initialization.CommandLineParser;
import org.gradle.initialization.ParsedCommandLine;
import org.gradle.logging.LoggingConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoggingCommandLineConverter
extends AbstractCommandLineConverter<LoggingConfiguration> {
    public static final String DEBUG = "d";
    public static final String INFO = "i";
    public static final String QUIET = "q";
    public static final String NO_COLOR = "no-color";
    private final BiMap<String, LogLevel> logLevelMap = HashBiMap.create();

    public LoggingCommandLineConverter() {
        this.logLevelMap.put((Object)QUIET, (Object)LogLevel.QUIET);
        this.logLevelMap.put((Object)INFO, (Object)LogLevel.INFO);
        this.logLevelMap.put((Object)DEBUG, (Object)LogLevel.DEBUG);
        this.logLevelMap.put((Object)"", (Object)LogLevel.LIFECYCLE);
    }

    @Override
    protected LoggingConfiguration newInstance() {
        return new LoggingConfiguration();
    }

    @Override
    public LoggingConfiguration convert(ParsedCommandLine commandLine, LoggingConfiguration loggingConfiguration) throws CommandLineArgumentException {
        loggingConfiguration.setLogLevel(this.getLogLevel(commandLine));
        if (commandLine.hasOption(NO_COLOR)) {
            loggingConfiguration.setColorOutput(false);
        }
        return loggingConfiguration;
    }

    private LogLevel getLogLevel(ParsedCommandLine options) {
        LogLevel logLevel = LogLevel.LIFECYCLE;
        if (options.hasOption(QUIET)) {
            logLevel = LogLevel.QUIET;
        }
        if (options.hasOption(INFO)) {
            logLevel = LogLevel.INFO;
        }
        if (options.hasOption(DEBUG)) {
            logLevel = LogLevel.DEBUG;
        }
        return logLevel;
    }

    @Override
    public void configure(CommandLineParser parser) {
        parser.option(DEBUG, "debug").hasDescription("Log in debug mode (includes normal stacktrace).");
        parser.option(QUIET, "quiet").hasDescription("Log errors only.");
        parser.option(INFO, "info").hasDescription("Set log level to info.");
        parser.option(NO_COLOR).hasDescription("Do not use color in the console output.");
    }

    public LogLevel getLogLevel(String commandLineArgument) {
        LogLevel logLevel = (LogLevel)((Object)this.logLevelMap.get((Object)commandLineArgument));
        if (logLevel == null) {
            return null;
        }
        return logLevel;
    }

    public String getLogLevelCommandLine(LogLevel logLevel) {
        String commandLine = (String)this.logLevelMap.inverse().get((Object)logLevel);
        if (commandLine == null) {
            return null;
        }
        return commandLine;
    }

    public Collection<LogLevel> getLogLevels() {
        return Collections.unmodifiableCollection(this.logLevelMap.values());
    }
}

