/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.logging.internal;

import org.gradle.logging.ProgressLogger;
import org.gradle.logging.ProgressLoggerFactory;
import org.gradle.logging.internal.ProgressCompleteEvent;
import org.gradle.logging.internal.ProgressEvent;
import org.gradle.logging.internal.ProgressListener;
import org.gradle.logging.internal.ProgressStartEvent;
import org.gradle.util.TimeProvider;

public class DefaultProgressLoggerFactory
implements ProgressLoggerFactory {
    private final ProgressListener progressListener;
    private final TimeProvider timeProvider;

    public DefaultProgressLoggerFactory(ProgressListener progressListener, TimeProvider timeProvider) {
        this.progressListener = progressListener;
        this.timeProvider = timeProvider;
    }

    public ProgressLogger start(String loggerCategory) {
        return this.start(loggerCategory, "");
    }

    public ProgressLogger start(String loggerCategory, String description) {
        ProgressLoggerImpl logger = new ProgressLoggerImpl(loggerCategory, description, this.progressListener, this.timeProvider);
        logger.started();
        return logger;
    }

    private static class ProgressLoggerImpl
    implements ProgressLogger {
        private final String category;
        private final String description;
        private final ProgressListener listener;
        private final TimeProvider timeProvider;
        private String status = "";
        private boolean completed;

        public ProgressLoggerImpl(String category, String description, ProgressListener listener, TimeProvider timeProvider) {
            this.category = category;
            this.description = description;
            this.listener = listener;
            this.timeProvider = timeProvider;
        }

        public String getDescription() {
            return this.description;
        }

        public String getStatus() {
            return this.status;
        }

        public void started() {
            this.listener.started(new ProgressStartEvent(this.timeProvider.getCurrentTime(), this.category, this.description));
        }

        public void progress(String status) {
            this.assertNotCompleted();
            this.status = status;
            this.listener.progress(new ProgressEvent(this.timeProvider.getCurrentTime(), this.category, status));
        }

        public void completed() {
            this.completed("");
        }

        public void completed(String status) {
            this.status = status;
            this.completed = true;
            this.listener.completed(new ProgressCompleteEvent(this.timeProvider.getCurrentTime(), this.category, status));
        }

        private void assertNotCompleted() {
            if (this.completed) {
                throw new IllegalStateException("This ProgressLogger has been completed.");
            }
        }
    }
}

