/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.listener;

import groovy.lang.Closure;
import org.gradle.api.Action;
import org.gradle.api.Transformer;
import org.gradle.messaging.dispatch.BroadcastDispatch;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ProxyDispatchAdapter;
import org.gradle.messaging.dispatch.StoppableDispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerBroadcast<T>
implements StoppableDispatch<MethodInvocation> {
    private final ProxyDispatchAdapter<T> source;
    private final BroadcastDispatch<T> broadcast;
    private final Class<T> type;
    private final StoppableDispatch<MethodInvocation> dispatch;

    public ListenerBroadcast(Class<T> type) {
        this(type, new Transformer<StoppableDispatch<MethodInvocation>>(){

            @Override
            public StoppableDispatch<MethodInvocation> transform(StoppableDispatch<MethodInvocation> original) {
                return original;
            }
        });
    }

    protected ListenerBroadcast(Class<T> type, Transformer<StoppableDispatch<MethodInvocation>> transformer) {
        this.type = type;
        this.broadcast = new BroadcastDispatch<T>(type);
        this.dispatch = transformer.transform(this.broadcast);
        this.source = new ProxyDispatchAdapter<T>(type, this.dispatch);
    }

    public T getSource() {
        return this.source.getSource();
    }

    public Class<T> getType() {
        return this.type;
    }

    public void add(T listener) {
        this.broadcast.add(listener);
    }

    public void addAll(Iterable<? extends T> listeners) {
        for (T listener : listeners) {
            this.broadcast.add(listener);
        }
    }

    public void maybeAdd(Object listener) {
        if (this.type.isInstance(listener)) {
            this.add(this.type.cast(listener));
        }
    }

    public void add(Dispatch<MethodInvocation> dispatch) {
        this.broadcast.add(dispatch);
    }

    public void add(String methodName, Closure closure) {
        this.broadcast.add(methodName, closure);
    }

    public void add(String methodName, Action<?> action) {
        this.broadcast.add(methodName, action);
    }

    public void remove(Object listener) {
        this.broadcast.remove(listener);
    }

    public void removeAll(Iterable<?> listeners) {
        for (Object listener : listeners) {
            this.remove(listener);
        }
    }

    @Override
    public void dispatch(MethodInvocation event) {
        this.dispatch.dispatch(event);
    }

    @Override
    public void stop() {
        this.dispatch.stop();
    }
}

