/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.listener;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.listener.ListenerBroadcast;
import org.gradle.listener.ListenerManager;
import org.gradle.messaging.dispatch.BroadcastDispatch;
import org.gradle.messaging.dispatch.Dispatch;
import org.gradle.messaging.dispatch.MethodInvocation;
import org.gradle.messaging.dispatch.ReflectionDispatch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultListenerManager
implements ListenerManager {
    private final Set<Object> allListeners = new LinkedHashSet<Object>();
    private final Set<Object> allLoggers = new LinkedHashSet<Object>();
    private final Map<Class<?>, ListenerBroadcast> broadcasters = new HashMap();
    private final Map<Class<?>, LoggerDispatch> loggers = new HashMap();
    private final Map<Class<?>, BroadcastDispatch> dispatchers = new HashMap();
    private final Object lock = new Object();
    private final DefaultListenerManager parent;

    public DefaultListenerManager() {
        this(null);
    }

    private DefaultListenerManager(DefaultListenerManager parent) {
        this.parent = parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(Object listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.allListeners.add(listener)) {
                for (BroadcastDispatch broadcaster : this.dispatchers.values()) {
                    this.maybeAddToDispatcher(broadcaster, listener);
                }
            }
        }
    }

    @Override
    public void addListener(Class<?> listenerType, String method, Closure listenerClosure) {
        this.addListener(new ClosureListener(listenerType, method, listenerClosure));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeListener(Object listener) {
        Object object = this.lock;
        synchronized (object) {
            if (this.allListeners.remove(listener)) {
                for (BroadcastDispatch broadcaster : this.dispatchers.values()) {
                    broadcaster.remove(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void useLogger(Object logger) {
        Object object = this.lock;
        synchronized (object) {
            if (this.allLoggers.add(logger)) {
                for (LoggerDispatch dispatch : this.loggers.values()) {
                    dispatch.maybeSetLogger(logger);
                }
            }
        }
    }

    @Override
    public <T> T getBroadcaster(Class<T> listenerClass) {
        return this.getBroadcasterInternal(listenerClass).getSource();
    }

    @Override
    public <T> ListenerBroadcast<T> createAnonymousBroadcaster(Class<T> listenerClass) {
        ListenerBroadcast<T> broadcast = new ListenerBroadcast<T>(listenerClass);
        broadcast.add(this.getBroadcasterInternal(listenerClass).getSource());
        return broadcast;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ListenerBroadcast<T> getBroadcasterInternal(Class<T> listenerClass) {
        Object object = this.lock;
        synchronized (object) {
            ListenerBroadcast<T> broadcaster = this.broadcasters.get(listenerClass);
            if (broadcaster == null) {
                broadcaster = new ListenerBroadcast<T>(listenerClass);
                broadcaster.add(this.getLogger(listenerClass));
                broadcaster.add(this.getDispatcher(listenerClass));
                if (this.parent != null) {
                    broadcaster.add(this.parent.getDispatcher(listenerClass));
                }
                this.broadcasters.put(listenerClass, broadcaster);
            }
            return broadcaster;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> BroadcastDispatch<T> getDispatcher(Class<T> listenerClass) {
        Object object = this.lock;
        synchronized (object) {
            BroadcastDispatch<T> dispatcher = this.dispatchers.get(listenerClass);
            if (dispatcher == null) {
                dispatcher = new BroadcastDispatch<T>(listenerClass);
                this.dispatchers.put(listenerClass, dispatcher);
                for (Object listener : this.allListeners) {
                    this.maybeAddToDispatcher(dispatcher, listener);
                }
            }
            return dispatcher;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerDispatch getLogger(Class<?> listenerClass) {
        Object object = this.lock;
        synchronized (object) {
            LoggerDispatch dispatch = this.loggers.get(listenerClass);
            if (dispatch == null) {
                dispatch = new LoggerDispatch(listenerClass, this.parent == null ? null : this.parent.getLogger(listenerClass));
                for (Object logger : this.allLoggers) {
                    dispatch.maybeSetLogger(logger);
                }
                this.loggers.put(listenerClass, dispatch);
            }
            return dispatch;
        }
    }

    private void maybeAddToDispatcher(BroadcastDispatch broadcaster, Object listener) {
        if (listener instanceof ClosureListener) {
            ClosureListener closureListener = (ClosureListener)listener;
            if (broadcaster.getType().isAssignableFrom(closureListener.listenerType)) {
                broadcaster.add(closureListener.method, closureListener.closure);
            }
        } else if (broadcaster.getType().isInstance(listener)) {
            broadcaster.add(listener);
        }
    }

    @Override
    public ListenerManager createChild() {
        return new DefaultListenerManager(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LoggerDispatch
    implements Dispatch<MethodInvocation> {
        private final Class<?> type;
        private Dispatch<MethodInvocation> dispatch;

        private LoggerDispatch(Class<?> type, LoggerDispatch parentDispatch) {
            this.type = type;
            this.dispatch = parentDispatch;
        }

        @Override
        public void dispatch(MethodInvocation message) {
            if (this.dispatch != null) {
                this.dispatch.dispatch(message);
            }
        }

        public void maybeSetLogger(Object logger) {
            if (this.type.isInstance(logger)) {
                this.dispatch = new ReflectionDispatch(logger);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClosureListener {
        final Class<?> listenerType;
        final String method;
        final Closure closure;

        private ClosureListener(Class<?> listenerType, String method, Closure closure) {
            this.listenerType = listenerType;
            this.method = method;
            this.closure = closure;
        }
    }
}

