/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.gradle.StartParameter;
import org.gradle.groovy.scripts.StringScriptSource;
import org.gradle.groovy.scripts.UriScriptSource;
import org.gradle.initialization.ISettingsFileSearchStrategy;
import org.gradle.initialization.ISettingsFinder;
import org.gradle.initialization.SettingsLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSettingsFinder
implements ISettingsFinder {
    private List<ISettingsFileSearchStrategy> settingsFileSearchStrategies;

    public DefaultSettingsFinder(List<ISettingsFileSearchStrategy> settingsFileSearchStrategies) {
        this.settingsFileSearchStrategies = settingsFileSearchStrategies;
    }

    @Override
    public SettingsLocation find(StartParameter startParameter) {
        ISettingsFileSearchStrategy settingsFileSearchStrategy;
        File settingsFile = null;
        Iterator<ISettingsFileSearchStrategy> i$ = this.settingsFileSearchStrategies.iterator();
        while (i$.hasNext() && (settingsFile = (settingsFileSearchStrategy = i$.next()).find(startParameter)) == null) {
        }
        if (settingsFile == null) {
            return new SettingsLocation(startParameter.getCurrentDir(), new StringScriptSource("empty settings file", ""));
        }
        return new SettingsLocation(settingsFile.getParentFile(), new UriScriptSource("settings file", settingsFile));
    }
}

