/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.List;
import java.util.Set;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLineOption {
    private final Set<String> options;
    private Class<?> argumentType = Void.TYPE;
    private String description;
    private String subcommand;

    public CommandLineOption(Iterable<String> options) {
        this.options = GUtil.addSets(options);
    }

    public Set<String> getOptions() {
        return this.options;
    }

    public CommandLineOption hasArgument() {
        this.argumentType = String.class;
        return this;
    }

    public CommandLineOption hasArguments() {
        this.argumentType = List.class;
        return this;
    }

    public String getSubcommand() {
        return this.subcommand;
    }

    public CommandLineOption mapsToSubcommand(String command) {
        this.subcommand = command;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public CommandLineOption hasDescription(String description) {
        this.description = description;
        return this;
    }

    public boolean getAllowsArguments() {
        return this.argumentType != Void.TYPE;
    }

    public boolean getAllowsMultipleArguments() {
        return this.argumentType == List.class;
    }
}

