/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.io.File;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.project.IProjectRegistry;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.initialization.AbstractProjectSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildFileProjectSpec
extends AbstractProjectSpec {
    private final File buildFile;

    public BuildFileProjectSpec(File buildFile) {
        this.buildFile = buildFile;
    }

    @Override
    public String getDisplayName() {
        return String.format("project has build file '%s'", this.buildFile);
    }

    @Override
    protected String formatNoMatchesMessage() {
        return String.format("No projects in this build have build file '%s'.", this.buildFile);
    }

    @Override
    protected String formatMultipleMatchesMessage(Iterable<? extends ProjectIdentifier> matches) {
        return String.format("Multiple projects in this build have build file '%s': %s", this.buildFile, matches);
    }

    @Override
    protected boolean select(ProjectIdentifier project) {
        return this.buildFile.equals(project.getBuildFile());
    }

    @Override
    protected void checkPreconditions(IProjectRegistry<?> registry) {
        if (!this.buildFile.exists()) {
            throw new InvalidUserDataException(String.format("Build file '%s' does not exist.", this.buildFile));
        }
        if (!this.buildFile.isFile()) {
            throw new InvalidUserDataException(String.format("Build file '%s' is not a file.", this.buildFile));
        }
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }
}

