/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.gradle.api.Task;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.specs.Spec;
import org.gradle.execution.DelegatingBuildExecuter;
import org.gradle.execution.ProjectDefaultsBuildExecuter;
import org.gradle.execution.TaskNameResolvingBuildExecuter;
import org.gradle.execution.TaskSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBuildExecuter
extends DelegatingBuildExecuter {
    private final Set<String> excludedTaskNames;

    public DefaultBuildExecuter(Collection<String> includedTaskNames, Collection<String> excludedTaskNames) {
        this.excludedTaskNames = new HashSet<String>(excludedTaskNames);
        if (includedTaskNames.isEmpty()) {
            this.setDelegate(new ProjectDefaultsBuildExecuter());
        } else {
            this.setDelegate(new TaskNameResolvingBuildExecuter(includedTaskNames));
        }
    }

    @Override
    public void select(GradleInternal gradle) {
        if (!this.excludedTaskNames.isEmpty()) {
            final HashSet<Task> excludedTasks = new HashSet<Task>();
            TaskSelector selector = new TaskSelector();
            for (String taskName : this.excludedTaskNames) {
                selector.selectTasks(gradle, taskName);
                excludedTasks.addAll(selector.getTasks());
            }
            gradle.getTaskGraph().useFilter((Spec<? super Task>)new Spec<Task>(){

                @Override
                public boolean isSatisfiedBy(Task task) {
                    return !excludedTasks.contains(task);
                }
            });
        }
        super.select(gradle);
    }
}

