/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.tasks.diagnostics.DependencyReportTask;
import org.gradle.api.tasks.diagnostics.ProjectReportTask;
import org.gradle.api.tasks.diagnostics.PropertyReportTask;
import org.gradle.api.tasks.diagnostics.TaskReportTask;
import org.gradle.configuration.Help;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImplicitTasksConfigurer
implements Action<ProjectInternal> {
    private static final String HELP_GROUP = "help";
    public static final String HELP_TASK = "help";
    public static final String PROJECTS_TASK = "projects";
    public static final String TASKS_TASK = "tasks";
    public static final String DEPENDENCIES_TASK = "dependencies";
    public static final String PROPERTIES_TASK = "properties";

    @Override
    public void execute(ProjectInternal project) {
        TaskContainerInternal tasks = project.getImplicitTasks();
        DefaultTask task = tasks.add("help", Help.class);
        task.setDescription("Displays a help message");
        task.setGroup("help");
        task = tasks.add(PROJECTS_TASK, ProjectReportTask.class);
        task.setDescription(String.format("Displays the sub-projects of %s.", project));
        task.setGroup("help");
        task = tasks.add(TASKS_TASK, TaskReportTask.class);
        task.setDescription(String.format("Displays the tasks in %s.", project));
        task.setGroup("help");
        task = tasks.add(DEPENDENCIES_TASK, DependencyReportTask.class);
        task.setDescription(String.format("Displays the dependencies of %s.", project));
        task.setGroup("help");
        task = tasks.add(PROPERTIES_TASK, PropertyReportTask.class);
        task.setDescription(String.format("Displays the properties of %s.", project));
        task.setGroup("help");
    }
}

