/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.configuration.ProjectEvaluator;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.util.Clock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildScriptProcessor
implements ProjectEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildScriptProcessor.class);
    private final ScriptPluginFactory configurerFactory;

    public BuildScriptProcessor(ScriptPluginFactory configurerFactory) {
        this.configurerFactory = configurerFactory;
    }

    public void evaluate(ProjectInternal project, ProjectStateInternal state) {
        LOGGER.info(String.format("Evaluating %s using %s.", project, project.getBuildScriptSource().getDisplayName()));
        Clock clock = new Clock();
        try {
            ScriptPlugin configurer = this.configurerFactory.create(project.getBuildScriptSource());
            configurer.apply(project);
        }
        catch (Exception e) {
            state.executed(e);
        }
        LOGGER.debug("Timing: Running the build script took " + clock.getTime());
    }
}

