/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.btree;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.LRUMap;
import org.gradle.cache.btree.BlockPayload;
import org.gradle.cache.btree.BlockPointer;
import org.gradle.cache.btree.BlockStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingBlockStore
implements BlockStore {
    private final BlockStore store;
    private final Map<BlockPointer, BlockPayload> dirty = new LinkedHashMap<BlockPointer, BlockPayload>();
    private final Map<BlockPointer, BlockPayload> indexBlockCache = new LRUMap(100);
    private final Set<Class<?>> cachableTypes = new HashSet();

    public CachingBlockStore(BlockStore store, Class<? extends BlockPayload> ... cacheableBlockTypes) {
        this.store = store;
        this.cachableTypes.addAll(Arrays.asList(cacheableBlockTypes));
    }

    @Override
    public void open(Runnable initAction, BlockStore.Factory factory) {
        this.store.open(initAction, factory);
    }

    @Override
    public void close() {
        this.flush();
        this.indexBlockCache.clear();
        this.store.close();
    }

    @Override
    public void clear() {
        this.dirty.clear();
        this.indexBlockCache.clear();
        this.store.clear();
    }

    @Override
    public void flush() {
        Iterator<BlockPayload> iterator = this.dirty.values().iterator();
        while (iterator.hasNext()) {
            BlockPayload block = iterator.next();
            iterator.remove();
            this.store.write(block);
        }
        this.store.flush();
    }

    @Override
    public void attach(BlockPayload block) {
        this.store.attach(block);
    }

    @Override
    public void remove(BlockPayload block) {
        this.dirty.remove(block.getPos());
        this.indexBlockCache.remove(block.getPos());
        this.store.remove(block);
    }

    @Override
    public <T extends BlockPayload> T readFirst(Class<T> payloadType) {
        T block = this.store.readFirst(payloadType);
        this.maybeCache(block);
        return block;
    }

    @Override
    public <T extends BlockPayload> T read(BlockPointer pos, Class<T> payloadType) {
        BlockPayload block = (BlockPayload)payloadType.cast(this.dirty.get(pos));
        if (block != null) {
            return (T)block;
        }
        block = (BlockPayload)payloadType.cast(this.indexBlockCache.get(pos));
        if (block != null) {
            return (T)block;
        }
        block = this.store.read(pos, payloadType);
        this.maybeCache(block);
        return (T)block;
    }

    @Override
    public void write(BlockPayload block) {
        this.store.attach(block);
        this.maybeCache(block);
        this.dirty.put(block.getPos(), block);
    }

    private <T extends BlockPayload> void maybeCache(T block) {
        if (this.cachableTypes.contains(block.getClass())) {
            this.indexBlockCache.put(block.getPos(), block);
        }
    }
}

