/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.btree;

import org.gradle.cache.btree.BlockPayload;
import org.gradle.cache.btree.BlockPointer;

public abstract class Block {
    static final int LONG_SIZE = 8;
    static final int INT_SIZE = 4;
    static final int SHORT_SIZE = 2;
    private BlockPayload payload;

    protected Block(BlockPayload payload) {
        this.payload = payload;
        payload.setBlock(this);
    }

    public BlockPayload getPayload() {
        return this.payload;
    }

    protected void detach() {
        this.payload.setBlock(null);
        this.payload = null;
    }

    public abstract BlockPointer getPos();

    public abstract int getSize();

    public abstract RuntimeException blockCorruptedException();

    public String toString() {
        return String.format("%s %s", this.payload.getClass().getSimpleName(), this.getPos());
    }

    public BlockPointer getNextPos() {
        return new BlockPointer(this.getPos().getPos() + (long)this.getSize());
    }

    public abstract boolean hasPos();

    public abstract void setPos(BlockPointer var1);

    public abstract void setSize(int var1);
}

