/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.gradle.CacheUsage;
import org.gradle.cache.DefaultSerializer;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.Serializer;
import org.gradle.cache.SimpleStateCache;
import org.gradle.cache.btree.BTreePersistentIndexedCache;
import org.gradle.util.GFileUtils;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultPersistentDirectoryCache
implements PersistentCache {
    private final File dir;
    private final File propertiesFile;
    private final Properties properties = new Properties();
    private boolean valid;
    private BTreePersistentIndexedCache indexedCache;
    private SimpleStateCache stateCache;

    public DefaultPersistentDirectoryCache(File dir, CacheUsage cacheUsage, Map<String, ?> properties) {
        this.dir = dir;
        this.propertiesFile = new File(dir, "cache.properties");
        this.properties.putAll(properties);
        this.determineIfCacheIsValid(cacheUsage, properties);
        this.buildCacheDir();
    }

    public String toString() {
        return String.format("Cache %s", this.dir);
    }

    private void buildCacheDir() {
        if (!this.valid) {
            GFileUtils.deleteDirectory(this.dir);
        }
        if (!this.dir.isDirectory()) {
            this.dir.mkdirs();
        }
    }

    private void determineIfCacheIsValid(CacheUsage cacheUsage, Map<String, ?> properties) {
        this.valid = false;
        if (cacheUsage != CacheUsage.ON) {
            return;
        }
        if (!this.propertiesFile.isFile()) {
            return;
        }
        Properties currentProperties = GUtil.loadProperties(this.propertiesFile);
        for (Map.Entry<String, ?> entry : properties.entrySet()) {
            if (entry.getValue().toString().equals(currentProperties.getProperty(entry.getKey()))) continue;
            return;
        }
        this.valid = true;
    }

    public <K, V> BTreePersistentIndexedCache<K, V> openIndexedCache(Serializer<V> serializer) {
        if (this.indexedCache == null) {
            this.indexedCache = new BTreePersistentIndexedCache(this, serializer);
        }
        return this.indexedCache;
    }

    public <K, V> BTreePersistentIndexedCache<K, V> openIndexedCache() {
        return this.openIndexedCache((Serializer)new DefaultSerializer());
    }

    public <T> SimpleStateCache<T> openStateCache() {
        if (this.stateCache == null) {
            this.stateCache = new SimpleStateCache(this, new DefaultSerializer());
        }
        return this.stateCache;
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public File getBaseDir() {
        return this.dir;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    @Override
    public void markValid() {
        GUtil.saveProperties(this.properties, this.propertiesFile);
        this.valid = true;
    }

    public void close() {
        if (this.indexedCache != null) {
            this.indexedCache.close();
        }
    }
}

