/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.gradle.CacheUsage;
import org.gradle.api.invocation.Gradle;
import org.gradle.cache.CacheBuilder;
import org.gradle.cache.CacheFactory;
import org.gradle.cache.CacheRepository;
import org.gradle.cache.PersistentCache;
import org.gradle.util.GradleVersion;

public class DefaultCacheRepository
implements CacheRepository {
    private final GradleVersion version = new GradleVersion();
    private final File globalCacheDir;
    private final CacheUsage cacheUsage;
    private final CacheFactory factory;

    public DefaultCacheRepository(File userHomeDir, CacheUsage cacheUsage, CacheFactory factory) {
        this.factory = factory;
        this.globalCacheDir = new File(userHomeDir, "caches");
        this.cacheUsage = cacheUsage;
    }

    public CacheBuilder cache(String key) {
        return new PersistentCacheBuilder(key);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PersistentCacheBuilder
    implements CacheBuilder {
        private final String key;
        private Map<String, ?> properties = Collections.emptyMap();
        private Object target;
        private boolean invalidateOnVersionChange;

        private PersistentCacheBuilder(String key) {
            this.key = key;
        }

        @Override
        public CacheBuilder withProperties(Map<String, ?> properties) {
            this.properties = properties;
            return this;
        }

        @Override
        public CacheBuilder forObject(Object target) {
            this.target = target;
            return this;
        }

        @Override
        public CacheBuilder invalidateOnVersionChange() {
            this.invalidateOnVersionChange = true;
            return this;
        }

        @Override
        public PersistentCache open() {
            File cacheBaseDir;
            HashMap properties = new HashMap(this.properties);
            if (this.target == null) {
                cacheBaseDir = DefaultCacheRepository.this.globalCacheDir;
            } else if (this.target instanceof Gradle) {
                Gradle gradle = (Gradle)this.target;
                cacheBaseDir = new File(gradle.getRootProject().getProjectDir(), ".gradle");
            } else if (this.target instanceof File) {
                File dir = (File)this.target;
                cacheBaseDir = new File(dir, ".gradle");
            } else {
                throw new IllegalArgumentException(String.format("Cannot create cache for unrecognised domain object %s.", this.target));
            }
            if (this.invalidateOnVersionChange) {
                properties.put("gradle.version", DefaultCacheRepository.this.version.getVersion());
                cacheBaseDir = new File(cacheBaseDir, "noVersion");
            } else {
                cacheBaseDir = new File(cacheBaseDir, DefaultCacheRepository.this.version.getVersion());
            }
            return DefaultCacheRepository.this.factory.open(new File(cacheBaseDir, this.key), DefaultCacheRepository.this.cacheUsage, properties);
        }
    }
}

