/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceTask
extends ConventionTask
implements PatternFilterable {
    private final List<Object> source = new ArrayList<Object>();
    private final PatternFilterable patternSet = new PatternSet();

    @InputFiles
    @SkipWhenEmpty
    public FileTree getSource() {
        FileTree src = this.source.isEmpty() ? this.getDefaultSource() : this.getProject().files(new ArrayList<Object>(this.source)).getAsFileTree();
        return src == null ? this.getProject().files(new Object[0]).getAsFileTree() : src.matching(this.patternSet);
    }

    protected FileTree getDefaultSource() {
        return null;
    }

    public void setSource(Object source) {
        this.source.clear();
        this.source.add(source);
    }

    public SourceTask source(Object ... sources) {
        for (Object source : sources) {
            this.source.add(source);
        }
        return this;
    }

    @Override
    public SourceTask include(String ... includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public SourceTask include(Iterable<String> includes) {
        this.patternSet.include(includes);
        return this;
    }

    @Override
    public SourceTask include(Spec<FileTreeElement> includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public SourceTask include(Closure includeSpec) {
        this.patternSet.include(includeSpec);
        return this;
    }

    @Override
    public SourceTask exclude(String ... excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public SourceTask exclude(Iterable<String> excludes) {
        this.patternSet.exclude(excludes);
        return this;
    }

    @Override
    public SourceTask exclude(Spec<FileTreeElement> excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public SourceTask exclude(Closure excludeSpec) {
        this.patternSet.exclude(excludeSpec);
        return this;
    }

    @Override
    public Set<String> getIncludes() {
        return this.patternSet.getIncludes();
    }

    @Override
    public SourceTask setIncludes(Iterable<String> includes) {
        this.patternSet.setIncludes(includes);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.patternSet.getExcludes();
    }

    @Override
    public SourceTask setExcludes(Iterable<String> excludes) {
        this.patternSet.setExcludes(excludes);
        return this;
    }
}

