/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import groovy.lang.Closure;
import java.io.FilterReader;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.gradle.api.Action;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileCopyDetails;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.internal.file.copy.CopyActionImpl;
import org.gradle.api.internal.file.copy.CopySpecSource;
import org.gradle.api.internal.file.copy.ReadableCopySpec;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCopyTask
extends ConventionTask
implements CopySpec,
CopySpecSource {
    @TaskAction
    protected void copy() {
        this.configureRootSpec();
        this.getCopyAction().execute();
        this.setDidWork(this.getCopyAction().getDidWork());
    }

    protected void configureRootSpec() {
        FileCollection srcDirs;
        if (!this.getCopyAction().hasSource() && (srcDirs = this.getDefaultSource()) != null) {
            this.from(srcDirs);
        }
    }

    public FileCollection getDefaultSource() {
        return null;
    }

    @InputFiles
    @SkipWhenEmpty
    @Optional
    public FileCollection getSource() {
        return this.getCopyAction().hasSource() ? this.getCopyAction().getAllSource() : this.getDefaultSource();
    }

    protected abstract CopyActionImpl getCopyAction();

    @Override
    public ReadableCopySpec getRootSpec() {
        return this.getCopyAction().getRootSpec();
    }

    protected CopySpec getMainSpec() {
        return this.getCopyAction();
    }

    @Override
    public boolean isCaseSensitive() {
        return this.getMainSpec().isCaseSensitive();
    }

    @Override
    public void setCaseSensitive(boolean caseSensitive) {
        this.getMainSpec().setCaseSensitive(caseSensitive);
    }

    @Override
    public AbstractCopyTask from(Object ... sourcePaths) {
        this.getMainSpec().from(sourcePaths);
        return this;
    }

    @Override
    public AbstractCopyTask from(Object sourcePath, Closure c) {
        this.getMainSpec().from(sourcePath, c);
        return this;
    }

    @Override
    public CopySpec with(CopySpec ... sourceSpecs) {
        this.getMainSpec().with(sourceSpecs);
        return this;
    }

    @Override
    public AbstractCopyTask into(Object destDir) {
        this.getMainSpec().into(destDir);
        return this;
    }

    @Override
    public AbstractCopyTask into(Object destPath, Closure configureClosure) {
        this.getMainSpec().into(destPath, configureClosure);
        return this;
    }

    @Override
    public AbstractCopyTask include(String ... includes) {
        this.getMainSpec().include(includes);
        return this;
    }

    @Override
    public AbstractCopyTask include(Iterable<String> includes) {
        this.getMainSpec().include(includes);
        return this;
    }

    @Override
    public AbstractCopyTask include(Spec<FileTreeElement> includeSpec) {
        this.getMainSpec().include(includeSpec);
        return this;
    }

    @Override
    public AbstractCopyTask include(Closure includeSpec) {
        this.getMainSpec().include(includeSpec);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(String ... excludes) {
        this.getMainSpec().exclude(excludes);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(Iterable<String> excludes) {
        this.getMainSpec().exclude(excludes);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(Spec<FileTreeElement> excludeSpec) {
        this.getMainSpec().exclude(excludeSpec);
        return this;
    }

    @Override
    public AbstractCopyTask exclude(Closure excludeSpec) {
        this.getMainSpec().exclude(excludeSpec);
        return this;
    }

    @Override
    public AbstractCopyTask setIncludes(Iterable<String> includes) {
        this.getMainSpec().setIncludes(includes);
        return this;
    }

    @Override
    public Set<String> getIncludes() {
        return this.getMainSpec().getIncludes();
    }

    @Override
    public AbstractCopyTask setExcludes(Iterable<String> excludes) {
        this.getMainSpec().setExcludes(excludes);
        return this;
    }

    @Override
    public Set<String> getExcludes() {
        return this.getMainSpec().getExcludes();
    }

    @Override
    public AbstractCopyTask rename(Closure closure) {
        this.getMainSpec().rename(closure);
        return this;
    }

    @Override
    public AbstractCopyTask rename(String sourceRegEx, String replaceWith) {
        this.getMainSpec().rename(sourceRegEx, replaceWith);
        return this;
    }

    @Override
    public AbstractCopyTask rename(Pattern sourceRegEx, String replaceWith) {
        this.getMainSpec().rename(sourceRegEx, replaceWith);
        return this;
    }

    @Override
    public AbstractCopyTask filter(Map<String, ?> properties, Class<? extends FilterReader> filterType) {
        this.getMainSpec().filter(properties, filterType);
        return this;
    }

    @Override
    public AbstractCopyTask filter(Class<? extends FilterReader> filterType) {
        this.getMainSpec().filter(filterType);
        return this;
    }

    @Override
    public AbstractCopyTask filter(Closure closure) {
        this.getMainSpec().filter(closure);
        return this;
    }

    @Override
    public AbstractCopyTask expand(Map<String, ?> properties) {
        this.getMainSpec().expand(properties);
        return this;
    }

    @Override
    public int getDirMode() {
        return this.getMainSpec().getDirMode();
    }

    @Override
    public int getFileMode() {
        return this.getMainSpec().getFileMode();
    }

    @Override
    public AbstractCopyTask setDirMode(int mode) {
        this.getMainSpec().setDirMode(mode);
        return this;
    }

    @Override
    public AbstractCopyTask setFileMode(int mode) {
        this.getMainSpec().setFileMode(mode);
        return this;
    }

    @Override
    public AbstractCopyTask eachFile(Action<? super FileCopyDetails> action) {
        this.getMainSpec().eachFile(action);
        return this;
    }

    @Override
    public AbstractCopyTask eachFile(Closure closure) {
        this.getMainSpec().eachFile(closure);
        return this;
    }
}

