/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import groovy.lang.Closure;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.PathResolvingFileCollection;
import org.gradle.api.tasks.TaskInputs;
import org.gradle.util.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTaskInputs
implements TaskInputs {
    private final PathResolvingFileCollection inputFiles;
    private final FileResolver resolver;
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public DefaultTaskInputs(FileResolver resolver) {
        this.resolver = resolver;
        this.inputFiles = new PathResolvingFileCollection("task input files", resolver, null, new Object[0]);
    }

    @Override
    public boolean getHasInputs() {
        return !this.inputFiles.getSources().isEmpty() || !this.properties.isEmpty();
    }

    @Override
    public FileCollection getFiles() {
        return this.inputFiles;
    }

    @Override
    public TaskInputs files(Object ... paths) {
        this.inputFiles.from(paths);
        return this;
    }

    @Override
    public TaskInputs file(Object path) {
        this.files(path);
        return this;
    }

    @Override
    public TaskInputs dir(Object dirPath) {
        this.inputFiles.from(this.resolver.resolveFilesAsTree(dirPath));
        return this;
    }

    @Override
    public Map<String, Object> getProperties() {
        HashMap<String, Object> actualProperties = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : this.properties.entrySet()) {
            Object value = this.unwrap(entry.getValue());
            actualProperties.put(entry.getKey(), value);
        }
        return actualProperties;
    }

    private Object unwrap(Object value) {
        while (true) {
            if (value instanceof Callable) {
                Callable callable = (Callable)value;
                try {
                    value = callable.call();
                }
                catch (Exception e) {
                    throw UncheckedException.asUncheckedException(e);
                }
            }
            if (!(value instanceof Closure)) break;
            Closure closure = (Closure)value;
            value = closure.call();
        }
        if (value instanceof FileCollection) {
            FileCollection fileCollection = (FileCollection)value;
            return fileCollection.getFiles();
        }
        return value;
    }

    @Override
    public TaskInputs property(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    @Override
    public TaskInputs properties(Map<String, ?> properties) {
        this.properties.putAll(properties);
        return this;
    }
}

