/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.OutputFile;
import org.gradle.util.GFileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputFilePropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final ValidationAction ouputFileValidation = new ValidationAction(){

        public void validate(String propertyName, Object value) throws InvalidUserDataException {
            File fileValue = GFileUtils.canonicalise((File)value);
            if (fileValue.exists() && !fileValue.isFile()) {
                throw new InvalidUserDataException(String.format("Cannot write to file '%s' specified for property '%s' as it is a directory.", fileValue, propertyName));
            }
            if (!fileValue.getParentFile().isDirectory() && !fileValue.getParentFile().mkdirs()) {
                throw new InvalidUserDataException(String.format("Cannot create parent directory '%s' of file specified for property '%s'.", fileValue.getParentFile(), propertyName));
            }
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return OutputFile.class;
    }

    @Override
    public void attachActions(PropertyActionContext context) {
        context.setValidationAction(this.ouputFileValidation);
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, Callable<Object> futureValue) {
                task.getOutputs().files(futureValue);
            }
        });
    }
}

