/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.OutputDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputDirectoryPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final ValidationAction outputDirValidation = new ValidationAction(){

        public void validate(String propertyName, Object value) throws InvalidUserDataException {
            File fileValue = (File)value;
            if (!fileValue.isDirectory() && !fileValue.mkdirs()) {
                throw new InvalidUserDataException(String.format("Cannot create directory '%s' specified for property '%s'.", fileValue, propertyName));
            }
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return OutputDirectory.class;
    }

    @Override
    public void attachActions(PropertyActionContext context) {
        context.setValidationAction(this.outputDirValidation);
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, Callable<Object> futureValue) {
                task.getOutputs().files(futureValue);
            }
        });
    }
}

