/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.SkipWhenEmpty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputFilesPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final ValidationAction skipEmptyFileCollection = new ValidationAction(){

        public void validate(String propertyName, Object value) throws InvalidUserDataException {
            if (value instanceof FileCollection) {
                ((FileCollection)value).stopExecutionIfEmpty();
            }
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return InputFiles.class;
    }

    @Override
    public void attachActions(PropertyActionContext context) {
        if (context.getTarget().getAnnotation(SkipWhenEmpty.class) != null) {
            context.setSkipAction(this.skipEmptyFileCollection);
        }
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, Callable<Object> futureValue) {
                task.getInputs().files(futureValue);
            }
        });
    }
}

