/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project.taskfactory;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.Task;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.internal.project.taskfactory.PropertyActionContext;
import org.gradle.api.internal.project.taskfactory.PropertyAnnotationHandler;
import org.gradle.api.internal.project.taskfactory.UpdateAction;
import org.gradle.api.internal.project.taskfactory.ValidationAction;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.StopExecutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputDirectoryPropertyAnnotationHandler
implements PropertyAnnotationHandler {
    private final ValidationAction inputDirValidation = new ValidationAction(){

        public void validate(String propertyName, Object value) throws InvalidUserDataException {
            File fileValue;
            File file = fileValue = value instanceof ConfigurableFileTree ? ((ConfigurableFileTree)value).getDir() : (File)value;
            if (!fileValue.exists()) {
                throw new InvalidUserDataException(String.format("Directory '%s' specified for property '%s' does not exist.", fileValue, propertyName));
            }
            if (!fileValue.isDirectory()) {
                throw new InvalidUserDataException(String.format("Directory '%s' specified for property '%s' is not a directory.", fileValue, propertyName));
            }
        }
    };
    private final ValidationAction skipEmptyDirectoryAction = new ValidationAction(){

        public void validate(String propertyName, Object value) throws InvalidUserDataException {
            File fileValue = (File)value;
            if (!fileValue.exists() || fileValue.isDirectory() && fileValue.list().length == 0) {
                throw new StopExecutionException(String.format("Directory %s is empty or does not exist.", fileValue));
            }
        }
    };

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return InputDirectory.class;
    }

    @Override
    public void attachActions(PropertyActionContext context) {
        context.setValidationAction(this.inputDirValidation);
        if (context.getTarget().getAnnotation(SkipWhenEmpty.class) != null) {
            context.setSkipAction(this.skipEmptyDirectoryAction);
        }
        context.setConfigureAction(new UpdateAction(){

            @Override
            public void update(Task task, Callable<Object> futureValue) {
                task.getInputs().dir(futureValue);
            }
        });
    }
}

