/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import java.io.File;
import org.apache.tools.ant.BuildListener;
import org.gradle.api.AntBuilder;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Module;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.ClassGenerator;
import org.gradle.api.internal.Factory;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.artifacts.ConfigurationContainerFactory;
import org.gradle.api.internal.artifacts.DefaultModule;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.DefaultArtifactHandler;
import org.gradle.api.internal.artifacts.dsl.PublishArtifactFactory;
import org.gradle.api.internal.artifacts.dsl.SharedConventionRepositoryHandlerFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.DefaultDependencyHandler;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.artifacts.repositories.InternalRepository;
import org.gradle.api.internal.file.BaseDirConverter;
import org.gradle.api.internal.file.DefaultFileOperations;
import org.gradle.api.internal.file.DefaultTemporaryFileProvider;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.FileSource;
import org.gradle.api.internal.file.TemporaryFileProvider;
import org.gradle.api.internal.initialization.DefaultScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptClassLoaderProvider;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.DefaultConvention;
import org.gradle.api.internal.plugins.DefaultProjectsPluginContainer;
import org.gradle.api.internal.plugins.PluginRegistry;
import org.gradle.api.internal.project.DefaultAntBuilderFactory;
import org.gradle.api.internal.project.DefaultServiceRegistry;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ServiceRegistry;
import org.gradle.api.internal.project.ServiceRegistryFactory;
import org.gradle.api.internal.project.TaskInternalServiceRegistry;
import org.gradle.api.internal.project.ant.AntLoggingAdapter;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.DefaultTaskContainerFactory;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.PluginContainer;
import org.gradle.logging.LoggingManagerInternal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectInternalServiceRegistry
extends DefaultServiceRegistry
implements ServiceRegistryFactory {
    private final ProjectInternal project;

    public ProjectInternalServiceRegistry(ServiceRegistry parent, ProjectInternal project) {
        super(parent);
        this.project = project;
    }

    protected PluginRegistry createPluginRegistry(PluginRegistry parentRegistry) {
        return parentRegistry.createChild(this.get(ScriptClassLoaderProvider.class).getClassLoader());
    }

    protected FileResolver createFileResolver() {
        return new BaseDirConverter(this.project.getProjectDir());
    }

    protected LoggingManagerInternal createLoggingManager() {
        return this.getFactory(LoggingManagerInternal.class).create();
    }

    protected FileOperations createFileOperations() {
        return new DefaultFileOperations(this.get(FileResolver.class), this.project.getTasks(), this.get(TemporaryFileProvider.class));
    }

    protected TemporaryFileProvider createTemporaryFileProvider() {
        return new DefaultTemporaryFileProvider(new FileSource(){

            public File get() {
                return new File(ProjectInternalServiceRegistry.this.project.getBuildDir(), "tmp");
            }
        });
    }

    protected Factory<AntBuilder> createAntBuilderFactory() {
        return new DefaultAntBuilderFactory((BuildListener)new AntLoggingAdapter(), this.project);
    }

    protected PluginContainer createPluginContainer() {
        return new DefaultProjectsPluginContainer(this.get(PluginRegistry.class), this.project);
    }

    protected Factory<TaskContainerInternal> createTaskContainerInternal() {
        return new DefaultTaskContainerFactory(this.get(ClassGenerator.class), this.get(ITaskFactory.class), this.project);
    }

    protected Convention createConvention() {
        return new DefaultConvention();
    }

    protected Factory<RepositoryHandler> createRepositoryHandlerFactory(Factory<? extends RepositoryHandler> factory) {
        return new SharedConventionRepositoryHandlerFactory(factory, this.get(Convention.class));
    }

    protected RepositoryHandler createRepositoryHandler() {
        return this.getFactory(RepositoryHandler.class).create();
    }

    protected ConfigurationContainer createConfigurationContainer() {
        return this.get(ConfigurationContainerFactory.class).createConfigurationContainer(this.project.getRepositories(), this.get(DependencyMetaDataProvider.class), this.project);
    }

    protected ArtifactHandler createArtifactHandler() {
        return new DefaultArtifactHandler(this.get(ConfigurationContainer.class), this.get(PublishArtifactFactory.class));
    }

    protected ProjectFinder createProjectFinder() {
        return new ProjectFinder(){

            public Project getProject(String path) {
                return ProjectInternalServiceRegistry.this.project.project(path);
            }
        };
    }

    protected DependencyHandler createDependencyHandler() {
        return new DefaultDependencyHandler(this.get(ConfigurationContainer.class), this.get(DependencyFactory.class), this.get(ProjectFinder.class));
    }

    protected ScriptHandlerInternal createScriptHandler() {
        DefaultScriptHandlerFactory factory = new DefaultScriptHandlerFactory(this.getFactory(RepositoryHandler.class), this.get(ConfigurationContainerFactory.class), this.get(DependencyMetaDataProvider.class), this.get(DependencyFactory.class));
        ClassLoader parentClassLoader = this.project.getParent() != null ? this.project.getParent().getBuildscript().getClassLoader() : this.project.getGradle().getScriptClassLoader();
        return factory.create(this.project.getBuildScriptSource(), parentClassLoader, this.project);
    }

    protected DependencyMetaDataProvider createDependencyMetaDataProvider() {
        return new DependencyMetaDataProvider(){

            public InternalRepository getInternalRepository() {
                return ProjectInternalServiceRegistry.this.get(InternalRepository.class);
            }

            public File getGradleUserHomeDir() {
                return ProjectInternalServiceRegistry.this.project.getGradle().getGradleUserHomeDir();
            }

            public Module getModule() {
                return new DefaultModule(ProjectInternalServiceRegistry.this.project.getGroup().toString(), ProjectInternalServiceRegistry.this.project.getName(), ProjectInternalServiceRegistry.this.project.getVersion().toString(), ProjectInternalServiceRegistry.this.project.getStatus().toString());
            }
        };
    }

    @Override
    public ServiceRegistryFactory createFor(Object domainObject) {
        if (domainObject instanceof TaskInternal) {
            return new TaskInternalServiceRegistry(this, this.project, (TaskInternal)domainObject);
        }
        throw new UnsupportedOperationException();
    }
}

