/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.plugins.ObjectConfigurationAction;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.groovy.scripts.UriScriptSource;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObjectConfigurationAction
implements ObjectConfigurationAction {
    private final FileResolver resolver;
    private final ScriptPluginFactory configurerFactory;
    private final Set<Object> targets = new LinkedHashSet<Object>();
    private final Set<Runnable> actions = new LinkedHashSet<Runnable>();
    private final Object[] defaultTargets;

    public DefaultObjectConfigurationAction(FileResolver resolver, ScriptPluginFactory configurerFactory, Object ... defaultTargets) {
        this.resolver = resolver;
        this.configurerFactory = configurerFactory;
        this.defaultTargets = defaultTargets;
    }

    @Override
    public ObjectConfigurationAction to(Object ... targets) {
        GUtil.flatten(targets, this.targets);
        return this;
    }

    @Override
    public ObjectConfigurationAction from(final Object script) {
        this.actions.add(new Runnable(){

            public void run() {
                DefaultObjectConfigurationAction.this.applyScript(script);
            }
        });
        return this;
    }

    @Override
    public ObjectConfigurationAction plugin(final Class<? extends Plugin> pluginClass) {
        this.actions.add(new Runnable(){

            public void run() {
                DefaultObjectConfigurationAction.this.applyPlugin(pluginClass);
            }
        });
        return this;
    }

    @Override
    public ObjectConfigurationAction plugin(final String pluginId) {
        this.actions.add(new Runnable(){

            public void run() {
                DefaultObjectConfigurationAction.this.applyPlugin(pluginId);
            }
        });
        return this;
    }

    private void applyScript(Object script) {
        URI scriptUri = this.resolver.resolveUri(script);
        ScriptPlugin configurer = this.configurerFactory.create(new UriScriptSource("script", scriptUri));
        for (Object target : this.targets) {
            configurer.apply(target);
        }
    }

    private void applyPlugin(Class<? extends Plugin> pluginClass) {
        for (Object target : this.targets) {
            if (target instanceof Project) {
                Project project = (Project)target;
                project.getPlugins().apply(pluginClass);
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    private void applyPlugin(String pluginId) {
        for (Object target : this.targets) {
            if (target instanceof Project) {
                Project project = (Project)target;
                project.getPlugins().apply(pluginId);
                continue;
            }
            throw new UnsupportedOperationException();
        }
    }

    public void execute() {
        if (this.targets.isEmpty()) {
            this.to(this.defaultTargets);
        }
        for (Runnable action : this.actions) {
            action.run();
        }
    }
}

