/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.plugins;

import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gradle.api.internal.BeanDynamicObject;
import org.gradle.api.plugins.Convention;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractConvention
implements Convention {
    private final Map<String, Object> plugins = new LinkedHashMap<String, Object>();

    @Override
    public Map<String, Object> getPlugins() {
        return this.plugins;
    }

    @Override
    public boolean hasProperty(String property) {
        for (Object object : this.plugins.values()) {
            if (!new BeanDynamicObject(object).hasProperty(property)) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> getProperties() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        ArrayList<Object> reverseOrder = new ArrayList<Object>(this.plugins.values());
        Collections.reverse(reverseOrder);
        for (Object e : reverseOrder) {
            properties.putAll(new BeanDynamicObject(e).getProperties());
        }
        return properties;
    }

    @Override
    public Object getProperty(String name) throws MissingPropertyException {
        BeanDynamicObject dynamicObject = new BeanDynamicObject(this);
        if (dynamicObject.hasProperty(name)) {
            return dynamicObject.getProperty(name);
        }
        for (Object object : this.plugins.values()) {
            dynamicObject = new BeanDynamicObject(object);
            if (!dynamicObject.hasProperty(name)) continue;
            return dynamicObject.getProperty(name);
        }
        throw new MissingPropertyException(name, Convention.class);
    }

    @Override
    public void setProperty(String property, Object value) {
        for (Object object : this.plugins.values()) {
            BeanDynamicObject dynamicObject = new BeanDynamicObject(object);
            if (!dynamicObject.hasProperty(property)) continue;
            dynamicObject.setProperty(property, value);
            return;
        }
        throw new MissingPropertyException(property, Convention.class);
    }

    @Override
    public Object invokeMethod(String name, Object ... arguments) {
        for (Object object : this.plugins.values()) {
            BeanDynamicObject dynamicObject = new BeanDynamicObject(object);
            if (!dynamicObject.hasMethod(name, arguments)) continue;
            return dynamicObject.invokeMethod(name, arguments);
        }
        throw new MissingMethodException(name, Convention.class, arguments);
    }

    @Override
    public boolean hasMethod(String method, Object ... args) {
        for (Object object : this.plugins.values()) {
            BeanDynamicObject dynamicObject = new BeanDynamicObject(object);
            if (!dynamicObject.hasMethod(method, args)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <T> T getPlugin(Class<T> type) {
        T value = this.findPlugin(type);
        if (value == null) {
            throw new IllegalStateException(String.format("Could not find any convention object of type %s.", type.getSimpleName()));
        }
        return value;
    }

    @Override
    public <T> T findPlugin(Class<T> type) throws IllegalStateException {
        ArrayList<T> values = new ArrayList<T>();
        for (Object object : this.plugins.values()) {
            if (!type.isInstance(object)) continue;
            values.add(type.cast(object));
        }
        if (values.isEmpty()) {
            return null;
        }
        if (values.size() > 1) {
            throw new IllegalStateException(String.format("Found multiple convention objects of type %s.", type.getSimpleName()));
        }
        return (T)values.get(0);
    }
}

