/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.DomainObjectContext;
import org.gradle.api.internal.Factory;
import org.gradle.api.internal.artifacts.ConfigurationContainerFactory;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.artifacts.dsl.dependencies.DefaultDependencyHandler;
import org.gradle.api.internal.artifacts.dsl.dependencies.DependencyFactory;
import org.gradle.api.internal.artifacts.dsl.dependencies.ProjectFinder;
import org.gradle.api.internal.initialization.DefaultScriptHandler;
import org.gradle.api.internal.initialization.NoClassLoaderUpdateScriptHandler;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.util.ObservableUrlClassLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultScriptHandlerFactory
implements ScriptHandlerFactory {
    private final Factory<? extends RepositoryHandler> repositoryHandlerFactory;
    private final ConfigurationContainerFactory configurationContainerFactory;
    private final DependencyMetaDataProvider dependencyMetaDataProvider;
    private final DependencyFactory dependencyFactory;
    private final Map<Collection<Object>, ObservableUrlClassLoader> classLoaderCache = new HashMap<Collection<Object>, ObservableUrlClassLoader>();
    private final ProjectFinder projectFinder = new ProjectFinder(){

        public Project getProject(String path) {
            throw new UnknownProjectException("Cannot use project dependencies in a script classpath definition.");
        }
    };

    public DefaultScriptHandlerFactory(Factory<? extends RepositoryHandler> repositoryHandlerFactory, ConfigurationContainerFactory configurationContainerFactory, DependencyMetaDataProvider dependencyMetaDataProvider, DependencyFactory dependencyFactory) {
        this.repositoryHandlerFactory = repositoryHandlerFactory;
        this.configurationContainerFactory = configurationContainerFactory;
        this.dependencyMetaDataProvider = dependencyMetaDataProvider;
        this.dependencyFactory = dependencyFactory;
    }

    @Override
    public ScriptHandlerInternal create(ScriptSource scriptSource, ClassLoader parentClassLoader) {
        return this.create(scriptSource, parentClassLoader, new BasicDomainObjectContext());
    }

    @Override
    public ScriptHandlerInternal create(ScriptSource scriptSource, ClassLoader parentClassLoader, DomainObjectContext context) {
        RepositoryHandler repositoryHandler = this.repositoryHandlerFactory.create();
        ConfigurationContainer configurationContainer = this.configurationContainerFactory.createConfigurationContainer(repositoryHandler, this.dependencyMetaDataProvider, context);
        DefaultDependencyHandler dependencyHandler = new DefaultDependencyHandler(configurationContainer, this.dependencyFactory, this.projectFinder);
        List<Object> key = Arrays.asList(scriptSource.getClassName(), parentClassLoader);
        ObservableUrlClassLoader classLoader = this.classLoaderCache.get(key);
        if (classLoader == null) {
            classLoader = new ObservableUrlClassLoader(parentClassLoader, new URL[0]);
            this.classLoaderCache.put(key, classLoader);
            return new DefaultScriptHandler(scriptSource, repositoryHandler, (DependencyHandler)dependencyHandler, configurationContainer, classLoader);
        }
        return new NoClassLoaderUpdateScriptHandler(classLoader, repositoryHandler, dependencyHandler, scriptSource, configurationContainer);
    }

    private static class BasicDomainObjectContext
    implements DomainObjectContext {
        private BasicDomainObjectContext() {
        }

        public String absoluteProjectPath(String name) {
            return name;
        }
    }
}

