/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.initialization;

import groovy.lang.Closure;
import java.io.File;
import java.net.URI;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.ObservableUrlClassLoader;

public abstract class AbstractScriptHandler
implements ScriptHandlerInternal {
    private final ScriptSource scriptSource;
    private final RepositoryHandler repositoryHandler;
    private final DependencyHandler dependencyHandler;
    private final ConfigurationContainer configContainer;
    private final ObservableUrlClassLoader classLoader;
    private final Configuration classpathConfiguration;

    public AbstractScriptHandler(ObservableUrlClassLoader classLoader, RepositoryHandler repositoryHandler, DependencyHandler dependencyHandler, ScriptSource scriptSource, ConfigurationContainer configContainer) {
        this.classLoader = classLoader;
        this.repositoryHandler = repositoryHandler;
        this.dependencyHandler = dependencyHandler;
        this.scriptSource = scriptSource;
        this.configContainer = configContainer;
        this.classpathConfiguration = configContainer.add("classpath");
    }

    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.dependencyHandler);
    }

    protected Configuration getClasspathConfiguration() {
        return this.classpathConfiguration;
    }

    public DependencyHandler getDependencies() {
        return this.dependencyHandler;
    }

    public RepositoryHandler getRepositories() {
        return this.repositoryHandler;
    }

    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.repositoryHandler);
    }

    public ConfigurationContainer getConfigurations() {
        return this.configContainer;
    }

    public ObservableUrlClassLoader getClassLoader() {
        return this.classLoader;
    }

    public File getSourceFile() {
        return this.scriptSource.getResource().getFile();
    }

    public URI getSourceURI() {
        return this.scriptSource.getResource().getURI();
    }
}

