/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.copy.CopySpecVisitor;
import org.gradle.api.internal.file.copy.DelegatingCopySpecVisitor;

public class NormalizingCopySpecVisitor
extends DelegatingCopySpecVisitor {
    private final Set<RelativePath> visitedDirs = new HashSet<RelativePath>();
    private final Map<RelativePath, FileVisitDetails> pendingDirs = new HashMap<RelativePath, FileVisitDetails>();

    public NormalizingCopySpecVisitor(CopySpecVisitor visitor) {
        super(visitor);
    }

    public void endVisit() {
        this.visitedDirs.clear();
        this.pendingDirs.clear();
        this.getVisitor().endVisit();
    }

    private void maybeVisit(RelativePath path) {
        if (path == null || path.getParent() == null || !this.visitedDirs.add(path)) {
            return;
        }
        this.maybeVisit(path.getParent());
        FileVisitDetails dir = this.pendingDirs.remove(path);
        if (dir == null) {
            dir = new FileVisitDetailsImpl(path);
        }
        this.getVisitor().visitDir(dir);
    }

    public void visitFile(FileVisitDetails fileDetails) {
        this.maybeVisit(fileDetails.getRelativePath().getParent());
        this.getVisitor().visitFile(fileDetails);
    }

    public void visitDir(FileVisitDetails dirDetails) {
        RelativePath path = dirDetails.getRelativePath();
        if (!this.visitedDirs.contains(path)) {
            this.pendingDirs.put(path, dirDetails);
        }
    }

    private static class FileVisitDetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final RelativePath path;
        private long lastModified = System.currentTimeMillis();

        private FileVisitDetailsImpl(RelativePath path) {
            this.path = path;
        }

        public String getDisplayName() {
            return this.path.toString();
        }

        public void stopVisiting() {
            throw new UnsupportedOperationException();
        }

        public File getFile() {
            throw new UnsupportedOperationException();
        }

        public boolean isDirectory() {
            throw new UnsupportedOperationException();
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public long getSize() {
            throw new UnsupportedOperationException();
        }

        public InputStream open() {
            throw new UnsupportedOperationException();
        }

        public RelativePath getRelativePath() {
            return this.path;
        }
    }
}

