/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.archive;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.gradle.api.GradleException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.AbstractFileTree;
import org.gradle.api.internal.file.AbstractFileTreeElement;
import org.gradle.api.internal.file.DefaultConfigurableFileTree;
import org.gradle.util.HashUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipFileTree
extends AbstractFileTree {
    private final File zipFile;
    private final File tmpDir;

    public ZipFileTree(File zipFile, File tmpDir) {
        this.zipFile = zipFile;
        String expandDirName = String.format("%s_%s", zipFile.getName(), HashUtil.createHash(zipFile.getAbsolutePath()));
        this.tmpDir = new File(tmpDir, expandDirName);
    }

    @Override
    public String getDisplayName() {
        return String.format("ZIP '%s'", this.zipFile);
    }

    @Override
    protected Collection<DefaultConfigurableFileTree> getAsFileTrees() {
        this.visitAll();
        return this.zipFile.exists() ? Collections.singleton(new DefaultConfigurableFileTree(this.tmpDir, null, null)) : Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileTree visit(FileVisitor visitor) {
        if (!this.zipFile.exists()) {
            return this;
        }
        if (!this.zipFile.isFile()) {
            throw new InvalidUserDataException(String.format("Cannot expand %s as it is not a file.", this));
        }
        AtomicBoolean stopFlag = new AtomicBoolean();
        try {
            ZipFile zip = new ZipFile(this.zipFile);
            try {
                TreeMap<String, ZipEntry> entriesByName = new TreeMap<String, ZipEntry>();
                Enumeration entries = zip.getEntries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = (ZipEntry)entries.nextElement();
                    entriesByName.put(entry.getName(), entry);
                }
                Iterator sortedEntries = entriesByName.values().iterator();
                while (!stopFlag.get() && sortedEntries.hasNext()) {
                    ZipEntry entry = (ZipEntry)sortedEntries.next();
                    if (entry.isDirectory()) {
                        visitor.visitDir(new DetailsImpl(entry, zip, stopFlag));
                        continue;
                    }
                    visitor.visitFile(new DetailsImpl(entry, zip, stopFlag));
                }
            }
            finally {
                zip.close();
            }
        }
        catch (Exception e) {
            throw new GradleException(String.format("Could not expand %s.", this), e);
        }
        return this;
    }

    private class DetailsImpl
    extends AbstractFileTreeElement
    implements FileVisitDetails {
        private final ZipEntry entry;
        private final ZipFile zip;
        private final AtomicBoolean stopFlag;
        private File file;

        public DetailsImpl(ZipEntry entry, ZipFile zip, AtomicBoolean stopFlag) {
            this.entry = entry;
            this.zip = zip;
            this.stopFlag = stopFlag;
        }

        public String getDisplayName() {
            return String.format("zip entry %s!%s", ZipFileTree.this.zipFile, this.entry.getName());
        }

        public void stopVisiting() {
            this.stopFlag.set(true);
        }

        public File getFile() {
            if (this.file == null) {
                this.file = new File(ZipFileTree.this.tmpDir, this.entry.getName());
                this.copyTo(this.file);
            }
            return this.file;
        }

        public long getLastModified() {
            return this.entry.getTime();
        }

        public boolean isDirectory() {
            return this.entry.isDirectory();
        }

        public long getSize() {
            return this.entry.getSize();
        }

        public InputStream open() {
            try {
                return this.zip.getInputStream(this.entry);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        public RelativePath getRelativePath() {
            return new RelativePath(!this.entry.isDirectory(), this.entry.getName().split("/"));
        }
    }
}

