/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.CompositeFileCollection;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnionFileCollection
extends CompositeFileCollection {
    private final Set<FileCollection> sourceCollections;

    public UnionFileCollection(FileCollection ... sourceCollections) {
        this(Arrays.asList(sourceCollections));
    }

    public UnionFileCollection(Iterable<? extends FileCollection> sourceCollections) {
        this.sourceCollections = GUtil.addToCollection(new LinkedHashSet(), sourceCollections);
    }

    @Override
    public String getDisplayName() {
        return "file collection";
    }

    @Override
    public FileCollection add(FileCollection collection) throws UnsupportedOperationException {
        this.sourceCollections.add(collection);
        return this;
    }

    @Override
    protected void addSourceCollections(Collection<FileCollection> sources) {
        sources.addAll(this.sourceCollections);
    }
}

